package com.jware.util.mail;

import java.util.ResourceBundle;

/**
 * @author jrmt
 * 
 */
public class MailResourceUtility {

	private ResourceBundle resources = null;

	public final static String DEFAULT_RESOURCE = "java.resources.MailResource";
	
	public MailResourceUtility(){
		
		resources = ResourceBundle.getBundle( DEFAULT_RESOURCE );

	}
	public MailResourceUtility( String resourceFile ){
		
		resources = ResourceBundle.getBundle( resourceFile );

	}

	/**
	 * @return Returns the resources.
	 */
	public ResourceBundle getResources() {
		return resources;
	}
	/**
	 * @param resources The resources to set.
	 */
	public void setResources(ResourceBundle resources) {
		this.resources = resources;
	}
	
	public String getResourceString( String key ) {
		
		String result = null;
		try {
			result = resources.getString( key );
		} catch ( Exception e ) {
			result = null;
		}

		return result;
	}
}
