package com.jware.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;


import org.apache.struts.upload.FormFile;

import com.jware.base.error.JwareApplicationException;

/**
 * @author jrmt
 *
 */
public class JwareUploader {

	private FileUploader uploader;
	
	private String filePath;
	
	private FormFile formFile;
	
	/**
	 * コンストラクタ
	 * @param key
	 */
	public JwareUploader(FormFile formFile,String filePath) {
		this.filePath = filePath;
		this.formFile = formFile;
	}
	
	/**
	 * ファイルのアップロードを行います。
	 * 
	 * @param formFile
	 * @return
	 * @throws JwareApplicationException
	 */
	public List executeWithZipExtract( boolean extractFlg ) throws JwareApplicationException {

		List fileNames = null;
		// ファイル名を設定
		String fileName = formFile.getFileName();
		
		// ファイルが設定されてある場合のみ、ファイルを保存
		if (!"".equals(fileName)) {
			
			// 送信されたファイルを保存
			uploader = new FileUploader(formFile);
			
			fileNames = uploader.executeWithZipExtract(ResourceUtility.DEFAULT_RESOURCE, filePath, extractFlg);
	
		}
		
		return fileNames;
		
	}

	/**
	 * ファイルのアップロードを行います。
	 * 
	 * @param formFile
	 * @return
	 * @throws JwareApplicationException
	 */
	public String execute() throws JwareApplicationException {

		// ファイル名を設定
		String fileName = formFile.getFileName();
		String imageFileName = null;
		
		// ファイルが設定されてある場合のみ、ファイルを保存
		if ("".equals(fileName)) {
			
			imageFileName = fileName;

		} else {
			
			imageFileName = getFileName(fileName);
	
			// 送信されたファイルを保存
			uploader = new FileUploader(formFile);
			uploader.setFileName(imageFileName);
			uploader.execute(ResourceUtility.DEFAULT_RESOURCE, filePath);
	
		}
		
		return imageFileName;
	}

	/**
	 * ファイルのアップロードを行います。
	 * 
	 * @param formFile
	 * @return
	 * @throws JwareApplicationException
	 */
	public String execute(String uploadfileName) throws JwareApplicationException {

		// ファイル名を設定
		String fileName = formFile.getFileName();
		String imageFileName = uploadfileName;
		
		imageFileName = adjustFileExtension(fileName, uploadfileName );

		// ファイルが設定されてある場合のみ、ファイルを保存
		if (!"".equals(fileName)) {
			
			String fullpath = filePath + System.getProperty("file.separator") + imageFileName;
			
			File file = new File( fullpath );
			if( file.exists() ){
				imageFileName = getFileName(fileName);
			}
			
			// 送信されたファイルを保存
			uploader = new FileUploader(formFile);
			uploader.setFileName(imageFileName);
			uploader.execute(ResourceUtility.DEFAULT_RESOURCE, filePath);
	
		}
		
		return imageFileName;
	}


	/**
	 * ファイル名を作成する。
	 * 
	 * @param fileName ファイル名
	 */
	private String getFileName(String fileName) {

		if (fileName == null || "".equals(fileName.trim())){
			return "";
		}

		int index = fileName.lastIndexOf('.');
		if (index == -1) {
			return "";
		}
		
		// 拡張子取得
		String extension = fileName.substring(index);

		if ("".equals(extension)){
			extension = ".txt";
		} else if ("jpeg".equals(extension)) {
			extension = ".jpg";
		}

		String[] arr = DateUtils.getYYYYMMDDHHMISSArray();
		String saveFileName = "img" + arr[0] + arr[1] + arr[2] + arr[3] + arr[4] + arr[5] + extension;

		return saveFileName;
		
	}
	
	/**
	 * ファイル拡張命を作成する。
	 * 
	 * @param fileName ファイル名
	 */
	private String adjustFileExtension(String oldName, String newName ) {

		String newFileName = newName;
		
		if (oldName == null || "".equals(oldName.trim())){
			return "";
		}

		int index = oldName.lastIndexOf('.');
		if (index == -1) {
			return "";
		}
		
		// 拡張子取得
		String extension = oldName.substring(index);

		if ( newName == null || "".equals(newName.trim())){
			return "";
		}

		index = newName.lastIndexOf('.');
		if (index >= 0 ) {
			newFileName = newName.substring( 0, index ) + extension;
		} else {
			newFileName = newName + extension;
		}

		return newFileName;
		
	}
	


}
