package com.jware.apps.scheduler.web.struts.schedule;

import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

import com.jware.apps.scheduler.model.JobDetailViewHelper;
import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.base.web.struts.jWareBaseAction;

/**
 * @author Jrmt
*/
public final class JobScheduleList extends jWareBaseAction {

    /**
     * Commons Logging instance.
    */
    private Log log = LogFactory.getLog(this.getClass().getName());

	/** 
	 * Process the specified HTTP request, and create the corresponding HTTP
	 * response (or forward to another web component that will create it).
	 * Return an <code>ActionForward</code> instance describing where and how
	 * control should be forwarded, or <code>null</code> if the response has
	 * already been completed.
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 * @param errors The ActionErrors created in BaseAction
	 * @param mochFlag The flag using Mocha
	 *
	 * @exception Exception if an input/output error or servlet exception occurs
	 */
	public ActionForward doExecute(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response,
				 ActionErrors errors,
				 boolean mochaFlag)
	throws Exception {

		// Extract attributes we will need
		HttpSession session = request.getSession();
		Locale locale = getLocale(request);
	
		MessageResources messages = getResources(request);
	
		if (log.isDebugEnabled()) {
			log.debug("JobDefinitionList:  Processing actions");
		}
			
		ArrayList jobList = new ArrayList();
		
		Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
		try {
	
			String[] jobGroups = scheduler.getJobGroupNames();
	
			ArrayList addedJobs = new ArrayList(jobGroups.length);
			//
			// have had some problems multiple jobs showing
			for (int i = 0; i < jobGroups.length; i++) {
				String groupName = jobGroups[i];
				String[] jobs = scheduler.getJobNames(groupName);
				for (int j = 0; j < jobs.length; j++) {
					String job = jobs[j];
					JobDetailViewHelper viewHelper = new JobDetailViewHelper();
					JobDetail jobDetail =scheduler.getJobDetail(job, groupName);
					String key = job + groupName;
					if (!addedJobs.contains(key)) {
						viewHelper.setJobDetail( jobDetail );
						viewHelper.putParamValue( "jobName", job );
						viewHelper.putParamValue( "groupName", groupName );
						jobList.add(viewHelper);
						addedJobs.add(key);
					}
				}
			}
			
		} catch (SchedulerException e) {
			throw new Exception("When reading the jobs", e);
		}
		
		request.setAttribute( "jobScheduleList", jobList );
		
		return mapping.findForward("success");
	
    }

}

