package com.jware.apps.scheduler.web.struts.schedule;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

import com.jware.apps.scheduler.model.JobParameterValue;
import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.base.web.struts.jWareBaseAction;

/**
 * @author Jrmt
*/
public final class JobEdit extends jWareBaseAction {

    /**
     * Commons Logging instance.
    */
    private Log log = LogFactory.getLog(this.getClass().getName());

	/** 
	 * Process the specified HTTP request, and create the corresponding HTTP
	 * response (or forward to another web component that will create it).
	 * Return an <code>ActionForward</code> instance describing where and how
	 * control should be forwarded, or <code>null</code> if the response has
	 * already been completed.
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 * @param errors The ActionErrors created in BaseAction
	 * @param mochFlag The flag using Mocha
	 *
	 * @exception Exception if an input/output error or servlet exception occurs
	 */
	public ActionForward doExecute(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response,
				 ActionErrors errors,
				 boolean mochaFlag)
	throws Exception {

		// Extract attributes we will need
		HttpSession session = request.getSession();
		Locale locale = getLocale(request);
		
		JobEditForm info = (JobEditForm)form;
		
		MessageResources messages = getResources(request);
		
		if (log.isDebugEnabled()) {
			log.debug("JobEdit:  Processing actions");
		}

		if( info == null ){
			info = new JobEditForm();
		}
		JobDetail jobDetail = null;
		String jobName = request.getParameter( "jobName" );
		String groupName = request.getParameter( "groupName" );
		if( jobName != null && groupName != null ){

			Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
			jobDetail = scheduler.getJobDetail( jobName, groupName );
			
			if( jobDetail != null ){
				
				info.setName(jobName);
				info.setGroupName( groupName );
				info.setDescription(jobDetail.getDescription());
				info.setDescription(jobDetail.getDescription());
				info.setJobClass(jobDetail.getJobClass().getName());
				info.setVolatility(jobDetail.isVolatile());
				info.setDurable(jobDetail.isDurable());

				JobDataMap jobDataMap = jobDetail.getJobDataMap();
				List parameters = new LinkedList();

				String[] parameterNames = jobDataMap.getKeys();
				for(int i=0; i<parameterNames.length;i++){
					String parameterName = parameterNames[i];
					JobParameterValue jobParameterValue = new JobParameterValue();
					jobParameterValue.setParameterName( parameterName );
					jobParameterValue.setParameterValue( jobDataMap.getString( parameterName ) );
					parameters.add(jobParameterValue);
				}
				
				JobParameterValue jobParameterValue = new JobParameterValue("", "");
				parameters.add( jobParameterValue );
				jobParameterValue = new JobParameterValue("", "");
				parameters.add( jobParameterValue );
				info.setParameterCount( parameterNames.length+2 );
				info.setJobParameters( parameters );
				info.setParameterName( null );
				info.setParameterValue( null );
			}
		}
		
		if( info.getJobParameters() == null ){
			List parameters = new LinkedList();
			JobParameterValue jobParameterValue = new JobParameterValue("", "");
			parameters.add( jobParameterValue );
			jobParameterValue = new JobParameterValue("", "");
			parameters.add( jobParameterValue );
			info.setParameterCount( 2 );
			info.setJobParameters( parameters );
			info.setRecoveryRequesting( true );
			info.setDurable( true );
			info.setVolatility( false );
		}
		
		request.setAttribute( "jobEditForm", info );
		
		return mapping.findForward("success");
		
    }

}

