package com.jware.apps.login;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
/**
 * Implementation of <strong>Action</strong> that validates a registration form.
 *
 * @author David Wintefeldt
*/
public final class Logon extends Action {

    /**
     * Commons Logging instance.
    */
    private Log log = LogFactory.getLog(this.getClass().getName());

    /**
     * Process the specified HTTP request, and create the corresponding HTTP
     * response (or forward to another web component that will create it).
     * Return an <code>ActionForward</code> instance describing where and how
     * control should be forwarded, or <code>null</code> if the response has
     * already been completed.
     *
     * @param mapping The ActionMapping used to select this instance
     * @param actionForm The optional ActionForm bean for this request (if any)
     * @param request The HTTP request we are processing
     * @param response The HTTP response we are creating
     *
     * @exception Exception if an input/output error or servlet exception occurs
     */
    public ActionForward execute(ActionMapping mapping,
                 ActionForm form,
                 HttpServletRequest request,
                 HttpServletResponse response)
    throws Exception {

	// Extract attributes we will need
	HttpSession session = request.getSession();

  	String requestUserAgent = request.getHeader("User-Agent");
  	String requestAccept = request.getHeader("Accept");
  	String requestAcceptCharset = request.getHeader("Accept-Charset");
  	String requestAcceptEncoding = request.getHeader("Accept-Encoding");
  	String requestAcceptLanguage = request.getHeader("Accept-Language");
  	String requestAcceptAuthorization = request.getHeader("Accept-Authorization");
	
  	if( log.isDebugEnabled() ){
  	    log.debug("User-Agent="+requestUserAgent);
  	    log.debug("Accept="+requestAccept);
  	    log.debug("Accept-Charset="+requestAcceptCharset);
  	    log.debug("Accept-Encoding="+requestAcceptEncoding);
  	    log.debug("Accept-Language="+requestAcceptLanguage);
  	    log.debug("Accept-Authorization="+requestAcceptAuthorization);
  	    
  	}
  	
	Locale locale = getLocale(request);

	MessageResources messages = getResources(request);
	LogonForm info = (LogonForm)form;

	if (log.isDebugEnabled()) {
		log.debug("Logon:  Processing actions");
	}


	return mapping.findForward("success");
    }

}

