/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.Properties;

import org.compiere.util.Ctx;
import org.compiere.util.Msg;

import com.ampiere.web.struts.common.PopupBaseForm;


/**
 * @author Shinjirito
 *
 */
public class InfoPostalForm extends PopupBaseForm {
	private static final long serialVersionUID = 4548544954962757545L;

	private String region;
	private String regionLabel;
	private String city;
	private String cityLabel;
	private String address;
	private String addressLabel;
	private int countryId;

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getAddressLabel() {
		return addressLabel;
	}

	public void setAddressLabel(String addressLabel) {
		this.addressLabel = addressLabel;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCityLabel() {
		return cityLabel;
	}

	public void setCityLabel(String cityLabel) {
		this.cityLabel = cityLabel;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public String getRegionLabel() {
		return regionLabel;
	}

	public void setRegionLabel(String regionLabel) {
		this.regionLabel = regionLabel;
	}

	/**
	 *	Static Setup - set field value
	 */
	public void statInit(Ctx ctx) {
		super.statInit(ctx);
		setTitle(Msg.translate(ctx, "InfoPostal"));

		setValueLabel(Msg.translate(ctx, "Value"));
		setRegionLabel(Msg.translate(ctx, "Region"));
		setCityLabel(Msg.translate(ctx, "City"));
		setAddressLabel(Msg.translate(ctx, "Address"));
	}

	/**
	 *	Dynamic Init
	 *  @param bpName Postal name
	 *  @param whereClause where clause
	 */
	public void initInfo(String key)
	{
		//  Set Value
		if (key == null)
			key = "%";
		if (!key.endsWith("%"))
			key += "%";

		//	Put query string in Name if not numeric
		if (key.equals("%"))
			setValue(key);
		//	No Numbers entered
		else if ((key.indexOf("0")+key.indexOf("1")+key.indexOf("2")+key.indexOf("3")+key.indexOf("4") +key.indexOf("5")
			+key.indexOf("6")+key.indexOf("7")+key.indexOf("8")+key.indexOf("9")) == -10)
		{
			if (key.startsWith("%"))
				setValue(key);
			else
				setValue("%" + key);
		}
		//	Number entered
		else {
			setValue(key);
		}
	}	//	initInfo

	public int getCountryId() {
		return countryId;
	}

	public void setCountryId(int countryId) {
		this.countryId = countryId;
	}
}
