package com.ampiere.web.struts.ajax;

import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ajaxtags.servlets.BaseAjaxAction;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.WebEnv;

/**
 * this class all base of Application Ajax Action.
 * Check session info and needed things.
 * @author bato
 * @version $Revision: 1.1 $ $Date: 2010/01/13 11:52:00 $
 * @see BaseAjaxAction
 */
public abstract class BaseAjaxActionEx extends BaseAjaxAction {
	
	@Override
	public final String getXmlContent(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebEnv.initWeb(this.getServlet().getServletConfig()))
			throw new ServletException("BaseAjaxActionEx.init");
		return getXmlContent(mapping, form, request, response, null);
	}
	
	public abstract String getXmlContent(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response, Map param)throws Exception;

}
