package com.jware.util.object;

import java.util.HashMap;
import java.util.Map;

/**
 *  オブジェクトキャッシュ
 *  オブジェクトキャッシュ、オブジェクトのインスタンスを保存する、
 *  Identityでオブジェクトのlookup機能を提供する
 */
public class ObjectCache {
    /**
     * holds all cached object identities
     */
    private Map cachedObjects = new HashMap();
    /**
     *   デフォルトコンストラクタ
     */
    public ObjectCache() {
    }

    /**
     * キャッシュをクリアする
     */
    public void clear() {
        cachedObjects.clear();
    }

    /**
     *  オブジェクトの追加
     *  キャッシュにobjを追加する。
     *
     * @param oid  Identityオブジェクト、Objectのキーである
     * @param obj  保存するオブジェクト
     */
    public void cache(Identity oid, Object obj) {
        if (obj != null && oid != null) {
            cachedObjects.put(oid.toString(), obj);
        }
    }

    /**
     *  オブジェクトのLOOKUP
     *  キャッシュからオブジェクトをサーチする
     * @param oid  Objectのキーである
     * @return     見つからない場合、nullを戻る
     */
    public Object lookup(Identity oid) {
        Object obj = cachedObjects.get(oid.toString());
        return obj;
    }

    /**
     *  オブジェクトの消去
     *  キャッシュからオブジェクトを消去する
     * @param obj　消去されたオブジェクト
     */
    public void remove(Identity oid) {
        if (oid != null) {
            cachedObjects.remove(oid.toString());
        }
    }
}