package com.jware.util.mail;

import java.util.ResourceBundle;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jware.util.mail.MailResourceUtility;

/**
 * メール送信基盤クラス。
 */
public class SimpleMailSender {

	private final Log log = LogFactory.getLog( this.getClass() );

	private ResourceBundle myResources = null;
	
	public SimpleMailSender(){
		
		super();
		ResourceBundle myResources = (new MailResourceUtility()).getResources();
	}

    public boolean execute( BaseMailData mailData ) {

    	boolean result = false;
    	
    	
    	
    	return result;
    }


    public void configMailSender( BaseMailSender mailSender ) {
    	
    	if( mailSender != null ){
    		
    		mailSender.setSmtpDirectFlg( isSmtpDirectFlg() );
    		mailSender.setPopBeforeSmtp( isPopBeforeSmtp() );
    		mailSender.setShiftJISFlg( isShiftJISFlg() );
    		
    		mailSender.setServerOsEncode(getResourceString("ServerOsEncode"));
    		mailSender.setSmtpEncode(getResourceString("SmtpEncode"));
    		mailSender.setSmtpServerAddress(getResourceString("SmtpServerAddress"));
    		mailSender.setPopServerAddress(getResourceString("PopServerAddress"));
    		mailSender.setPopAccessUserName(getResourceString("PopAccessUserName"));
    		mailSender.setPopAccessPassword(getResourceString("PopAccessPassword"));
    		mailSender.setBccMailAdddress(getResourceString("BccMailAdddress"));
    		mailSender.setClientOsEncode(getResourceString("ClientOsEncode"));
    		mailSender.setFileEncodingType(getResourceString("FileEncodingType"));
    		mailSender.setFileDistination(getResourceString("FileDistination"));

    	}
    	
    }
    
    /**
	 * SmtpDirectFlgのチェックを設定ファイルより読み込む
	 * @return boolean
	 */
	public boolean isSmtpDirectFlg(){
		if(Pattern.matches("[Yy][Ee][Ss]", 
		myResources.getString("SmtpDirectFlg"))){
			return true;
		}
		return false;
	}

    /**
	 * PopBeforeSmtpのチェックを設定ファイルより読み込む
	 * @return boolean
	 */
	public boolean isPopBeforeSmtp(){
		if(Pattern.matches("[Yy][Ee][Ss]", 
		myResources.getString("PopBeforSmtp"))){
			return true;
		}
		return false;
	}

	/**
	 * ShiftJISFlgのチェックを設定ファイルより読み込む
	 * @return boolean
	 */
	public boolean isShiftJISFlg(){
		if(Pattern.matches("[Yy][Ee][Ss]", 
			getResourceString("ShiftJISFlg"))){
			return true;
		}
		return false;
	}

	public String getResourceString( String key ){

		String result = null;
		
		try {
			result = myResources.getString( key );
		} catch( Exception e ) {
			;
		}

		return result;
	}
}
