package com.jware.base.error;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * Mocha用checked Exception
 * 
 * @author Shigeaki Wakizaka
 *
 */
public class JwareApplicationException extends Exception {

    /**
     * 主原因
     */
	protected Throwable rootCause = null;
	
    /**
     * 階層を考慮したエラー
     */
	private List exceptions = new ArrayList();
	
    /**
     * Struts エラー対応　キー
     */
	private String messageKey = null;
	
    /**
     * メッセージのバンドル変数
     */	
	private Object[] messageBundleValues = null;


	public JwareApplicationException(){
		super();
	}
	
	public JwareApplicationException(String messageKey){
		super();
		this.messageKey = messageKey;
	}

	public JwareApplicationException(String messageKey,Throwable ex){
		super();
		this.messageKey = messageKey;
		this.rootCause = ex;
	}

	public JwareApplicationException(String messageKey,Object[] messageBundleValues){
		super();
		this.messageKey = messageKey;
		this.messageBundleValues = messageBundleValues;	
	}

	public JwareApplicationException(String messageKey,Object[] messageBundleValues ,Throwable ex){
		super();
		this.messageKey = messageKey;
		this.messageBundleValues = messageBundleValues;	
		this.rootCause = ex;
	}

	public List getExceptions() {
		return this.exceptions;
	}

	public void addException(JwareApplicationException ex) {
		exceptions.add(ex);
	}


	/**
	 * @return
	 */
	public Object[] getMessageBundleValues() {
		return this.messageBundleValues;
	}

	/**
	 * @return
	 */
	public String getMessageKey() {
		return this.messageKey;
	}
	
	/**
 	*	@return
	*/
	public Throwable getRootCause() {
		return this.rootCause;
	}
	
	/**
	 * @param objects
	 */
	public void setMessageBundleValues(Object[] messageBundleValues) {
		this.messageBundleValues = messageBundleValues;
	}

	/**
	 * @param string
	 */
	public void setMessageKey(String messageKey) {
		this.messageKey = messageKey;
	}

	/**
	 * @param throwable
	 */
	public void setRootCause(Throwable rootCause) {
		this.rootCause = rootCause;
	}

	/**
	 * 
	 */
	public void printStackTrace() {
		printStackTrace(System.err);
	}

	public void printStackTrace(PrintStream outStream) {
		printStackTrace(new PrintWriter(outStream));
	}

	public void printStackTrace(PrintWriter writer) {
		super.printStackTrace(writer);

		if (getRootCause() != null) {
			getRootCause().printStackTrace(writer);
			
		}

		writer.flush();

	}



}
