package com.jware.apps.scheduler.web.struts.schedule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import com.jware.apps.scheduler.model.JobParameterValue;
import com.jware.base.web.struts.jWareBaseForm;

/**
 * @author jrmt
 */
public class JobScheduleViewForm  extends jWareBaseForm implements Serializable {

	private String name;
	private String groupName;
	private String description;
	private String jobClass;
	private boolean volatility;
	private boolean durable = false;	
	private boolean stateful;	
	private boolean recoveryRequesting;
	
	private int parameterCount;
	private List jobParameters = new LinkedList();
	private List jobTriggers = new LinkedList();
	private List jobListeners = new LinkedList();
	
	private Map paramMap = new HashMap();
	
	public JobScheduleViewForm() {
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getJobClass() {
		return jobClass;
	}

	public void setJobClass(String jobClass) {
		this.jobClass = jobClass;
	}

	public boolean isVolatile() {
		return volatility;
	}

	public void setVolatile(boolean volatility) {
		this.volatility = volatility;
	}

	public boolean isRecoveryRequesting() {
		return recoveryRequesting;
	}

	public void setRecoveryRequesting(boolean recover) {
		this.recoveryRequesting = recover;
	}

	/**
	 * @return Returns the volatility.
	 */
	public boolean isVolatility() {
		return volatility;
	}
	/**
	 * @param volatility The volatility to set.
	 */
	public void setVolatility(boolean volatility) {
		this.volatility = volatility;
	}
	/**
	 * Returns the durable.
	 * @return boolean
	 */
	public boolean isDurable() {
		return durable;
	}

	/**
	 * Returns the stateful.
	 * @return boolean
	 */
	public boolean isStateful() {
		return stateful;
	}

	/**
	 * Sets the durable.
	 * @param durable The durable to set
	 */
	public void setDurable(boolean durable) {
		this.durable = durable;
	}

	/**
	 * Sets the stateful.
	 * @param stateful The stateful to set
	 */
	public void setStateful(boolean stateful) {
		this.stateful = stateful;
	}

	/**
	 * @return Returns the parameters.
	 */
	public List getJobParameters() {
		return jobParameters;
	}
	/**
	 * @param parameters The parameters to set.
	 */
	public void setJobParameters(List parameters) {
		this.jobParameters = parameters;
	}
	
	public void setJobParameters(HttpServletRequest request){

		jobParameters = new LinkedList();
		for(int i=0; i<parameterCount; i++ ){
			JobParameterValue jobParameterValue = new JobParameterValue();
			String parameterName = request.getParameter("parameter["+i+"].parameterName");
			String parameterValue = request.getParameter("parameter["+i+"].parameterValue");
			jobParameterValue.setParameterName( parameterName );
			jobParameterValue.setParameterValue( parameterValue );
			jobParameters.add(jobParameterValue);
		}
	}
	
	/**
	 * @return Returns the parameterCount.
	 */
	public int getParameterCount() {
		return parameterCount;
	}
	/**
	 * @param parameterCount The parameterCount to set.
	 */
	public void setParameterCount(int parameterCount) {
		this.parameterCount = parameterCount;
	}

    /**
     * Reset all properties to their default values.
     *
     * @param mapping The mapping used to select this instance
     * @param request The servlet request we are processing
     */
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    	/**
    	 * This will set LoginUserId From Session  
    	 */
    	super.reset(mapping, request);		
    	
    	/**
    	 * Reset all properties to their default values.
    	 */
    	this.name = null;
    	this.groupName = null;
    	this.description = null;
    	this.jobClass = null;
    	this.volatility = false;
    	this.durable = false;	
    	this.stateful = false;	
    	this.recoveryRequesting = false;

    	this.parameterCount = 0;
    	this.jobParameters = new LinkedList();
    	this.jobTriggers = new LinkedList();
    	this.jobListeners = new LinkedList();
		
    }

	/**
	 * @return Returns the jobTrigggers.
	 */
	public List getJobTriggers() {
		return jobTriggers;
	}
	/**
	 * @param jobTrigggers The jobTrigggers to set.
	 */
	public void setJobTriggers(List jobTrigggers) {
		this.jobTriggers = jobTrigggers;
	}
	/**
	 * @return Returns the jobListeners.
	 */
	public List getJobListeners() {
		return jobListeners;
	}
	/**
	 * @param jobListeners The jobListeners to set.
	 */
	public void setJobListeners(List jobListeners) {
		this.jobListeners = jobListeners;
	}
	/**
	 * @return Returns the paramMap.
	 */
	public Map getParamMap() {
		return paramMap;
	}
	/**
	 * @param paramMap The paramMap to set.
	 */
	public void setParamMap(Map paramMap) {
		this.paramMap = paramMap;
	}
}
