/*
 *  Copyright James House (c) 2001-2004
 *
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 *
 * This product uses and includes within its distribution, 
 * software developed by the Apache Software Foundation 
 *     (http://www.apache.org/)
 *
 */
package com.jware.apps.scheduler.web.struts.listener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.quartz.Scheduler;

import com.jware.apps.scheduler.util.JobSchedulerUtils;


/**
  *  FIXME: Document class no.ezone.quartz.web.action.EditListenersAction
  *
  * @since Feb 3, 2003
  * @version $Revision: 1.1 $
 * @author Erick Romson
 * @author Rene Eigenheer
  */

abstract public class EditListenersAction extends Action{

	private static transient final Log logger = LogFactory.getLog( EditListenersAction.class );	


	/** The field's value is $Id: EditListenersAction.java,v 1.1 2010/01/13 11:52:18 clmg Exp $ */
	public static final String CVS_INFO="$Id: EditListenersAction.java,v 1.1 2010/01/13 11:52:18 clmg Exp $";

    public static final String LISTENER_CLASS_PROP="listenerClass";
    public static final String LISTENER_NAME_PROP="listenerName";
    public static final String ACTION_KEY="action";
    public static final String DELETE_ACTION_PROP="delete";
    public static final String ADD_ACTION_PROP="add";

    public EditListenersAction()
    {
    }

    /**
     * Process the specified HTTP request, and create the corresponding HTTP
     * response (or forward to another web component that will create it).
     * Return an <code>ActionForward</code> instance describing where and how
     * control should be forwarded, or <code>null</code> if the response has
     * already been completed.
     *
     * @param mapping The ActionMapping used to select this instance
     * @param actionForm The optional ActionForm bean for this request (if any)
     * @param request The HTTP request we are processing
     * @param response The HTTP response we are creating
     *
     * @exception IOException if an input/output error occurs
     * @exception ServletException if a servlet exception occurs
     */
    public ActionForward execute(ActionMapping mapping,
				 ActionForm actionForm,
				 HttpServletRequest request,
				 HttpServletResponse response)
	throws IOException, ServletException {

        Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(request);

        logger.info("Enter action!!!!!!!!!!!!!!!!");

        // Validate the request parameters specified by the user
        ActionErrors errors = new ActionErrors();

        String action=request.getParameter(ACTION_KEY);
        if (action ==null)
        {
            logger.info("no action");
        }
        else if (action.equals(DELETE_ACTION_PROP))
        {
            String[] listenersToDelete=request.getParameterValues(LISTENER_NAME_PROP);
            for (int i = 0; i < listenersToDelete.length; i++)
            {
                String listenerToDelete = listenersToDelete[i];
                removeListener(listenerToDelete,scheduler);
            }

        }
        else if (action.equals(ADD_ACTION_PROP))
        {
            String newListenerClass=request.getParameter(LISTENER_CLASS_PROP);
            addListener(newListenerClass,scheduler);
        }

        if ((errors!=null)&&(errors.size()>0))
        {
            saveErrors(request, errors);
            return (new ActionForward(mapping.getInput()));
        }

        List jobListenerNames=new ArrayList();
        List jobListenerClasses=new ArrayList();

        addAllListenerNamesAndClasses(scheduler,jobListenerNames,jobListenerClasses);
        request.setAttribute("listenerNames",jobListenerNames);
        request.setAttribute("listenerClasses",jobListenerClasses);

        setRequest(request);

        // Forward control to the specified success URI
		return mapping.findForward("success");

	}

    abstract void removeListener(String name,Scheduler scheduler)throws ServletException;

    abstract void addListener(String name,Scheduler scheduler)throws ServletException;

    abstract void addAllListenerNamesAndClasses(Scheduler scheduler,List names,List classes)throws ServletException;

    abstract void setRequest(HttpServletRequest request);
}

/*
* CVS log:
* $Log: EditListenersAction.java,v $
* Revision 1.1  2010/01/13 11:52:18  clmg
* *** empty log message ***
*
* Revision 1.1  2008/09/30 12:26:28  clmg
* web version
*
* Revision 1.1  2006/09/25 14:20:45  hans
* Compiere Japan First Upload 20060925 Hans
*
* Revision 1.1  2006/09/25 13:15:18  hans
* Compiere Japan First Upload 20060925 Hans
*
* Revision 1.1  2006/03/08 12:15:46  jrmt
* Jirimuto added in 2006/03/08
*
* Revision 1.1  2006/03/07 16:43:05  jrmt
* Jirimuto added in 2006/03/08
*
* Revision 1.1  2006/03/07 13:57:47  jrmt
* Jirimuto added in 2006/03/07
*
* Revision 1.1  2005/10/06 18:58:03  jrmt
* 200501006 created by jirimuto
*
* Revision 1.1  2005/07/28 11:25:30  jrmt
* 20050728 added by jirimuto
*
* Revision 1.1  2005/04/17 10:40:18  jrmt
* 20050417 modified by jirimuto
*
* Revision 1.1  2005/04/13 05:43:52  jrmt
* 20050413 added by jirimuto
*
* Revision 1.1  2004/10/24 05:28:33  jrmt
* jrmt added 20041024
*
* Revision 1.2  2004/01/13 19:44:34  jhouse
* update copyright date to new year (2004)
*
* Revision 1.1  2003/10/03 18:15:28  sutter2k
* intial move of web app src
*
* Revision 1.2  2003/05/21 02:29:15  jhouse
* Preparing "head" for 1.2.0 work.
*
* Revision 1.2  2003/02/11 20:41:52  erik
* moved superclass
*
* Revision 1.1  2003/02/05 00:54:37  erik
* first draft
*
*/

