package com.jware.apps.scheduler.web.struts.definition;

import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import com.jware.apps.scheduler.model.DefinitionManager;
import com.jware.apps.scheduler.model.JobDefinition;
import com.jware.apps.scheduler.model.JobParameter;
import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.base.web.struts.jWareBaseAction;

/**
 * @author Jrmt
*/
public final class ParameterAddAction extends jWareBaseAction {

    /**
     * Commons Logging instance.
    */
    private Log log = LogFactory.getLog(this.getClass().getName());

	/** 
	 * Process the specified HTTP request, and create the corresponding HTTP
	 * response (or forward to another web component that will create it).
	 * Return an <code>ActionForward</code> instance describing where and how
	 * control should be forwarded, or <code>null</code> if the response has
	 * already been completed.
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 * @param errors The ActionErrors created in BaseAction
	 * @param mochFlag The flag using Mocha
	 *
	 * @exception Exception if an input/output error or servlet exception occurs
	 */
	public ActionForward doExecute(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response,
				 ActionErrors errors,
				 boolean mochaFlag)
	throws Exception {

		// Extract attributes we will need
		HttpSession session = request.getSession();
		Locale locale = getLocale(request);
		
		ParameterAddForm info = (ParameterAddForm)form;
		
		MessageResources messages = getResources(request);
	
		if (log.isDebugEnabled()) {
			log.debug("ParameterAddAction:  Processing actions");
		}
	
		ServletContext context = super.servlet.getServletContext();
		DefinitionManager definitionManager = (DefinitionManager)context.getAttribute(JobSchedulerUtils.JOB_DEFINITIONS_PROP);
		
		Map map = definitionManager.getDefinitions();
		
		if(  map.containsKey( info.getName() ) ){
			
			JobDefinition jobDefinition = definitionManager.getDefinition(info.getName());

			List parameters = jobDefinition.getParameters();
			boolean exist = false;
			for( int i=0; i<parameters.size(); i++){
			    JobParameter jobParameter = (JobParameter)parameters.get(i);
			    if( info.getParameterName().equals( jobParameter.getName() ) ){
					jobParameter.setName( info.getParameterName() );
					jobParameter.setDescription( info.getParameterDescription() );
					jobParameter.setRequired( info.getRequired() );
					exist = true;
			    }
			}
			if( exist == false ){
				JobParameter jobParameter = new JobParameter();
				jobParameter.setName( info.getParameterName() );
				jobParameter.setDescription( info.getParameterDescription() );
				jobParameter.setRequired( info.getRequired() );
				jobDefinition.addParameter( jobParameter );
			}
			
			session.setAttribute( "definitionName",  info.getName() );
		}
		
		return mapping.findForward("success");
		
    }

}

