/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Principal;
import java.util.Properties;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.ecs.AlignType;
import org.apache.ecs.HtmlColor;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h3;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.ampiere.util.ajax.AjaxJavascriptParts;


/**
 *  Web Login Page.
 *  <p>
 *  Page request:
 *  <pre>
 *  - Check database connection
 *  - LoginInfo from request?
 *      - Yes: DoLogin success ?
 *          - Yes: return (second) preferences page
 *          - No: return (first) user/password page
 *      - No: User Principal ?
 *          - Yes: DoLogin success ?
 *              - Yes: return (second) preferences page
 *              - No: return (first) user/password page
 *          - No: return (first) user/password page
 *  </pre>
 *
 *  @author Jorg Janke
 *  @version  $Id: WLogin.java,v 1.1 2010/01/13 11:51:46 clmg Exp $
 */
public class WLogin extends HttpServlet
{
	private static final long serialVersionUID = -2475317452678336560L;

	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());
	
	/**
	 *	Initialize
	 *  @param config confif
	 *  @throws ServletException
	 */
	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WLogin.init");
	}	//	init

	/**
	 * Get Servlet information
	 * @return servlet info
	 */
	public String getServletInfo()
	{
		return "Compiere Web Login";
	}	//	getServletInfo

	/**
	 *	Clean up
	 */
	public void destroy()
	{
		log.info("destroy");
		super.destroy();
	}	//	destroy


	/**
	 *	Process the HTTP Get request - forward to Post
	 *  @param request request
	 *  @param response response
	 *  @throws ServletException
	 *  @throws IOException
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException
	{
		log.info("doGet");
		doPost (request, response);
	}	//	doGet


	/**
	 *	Process the HTTP Post request.
	 *  <pre>
	 *  - Optionally create Session
	 *  - Check database connection
	 *  - LoginInfo from request?
	 *      - Yes: DoLogin success ?
	 *          - Yes: return (second) preferences page
	 *          - No: return (first) user/password page
	 *      - No: User Principal ?
	 *          - Yes: DoLogin success ?
	 *              - Yes: return (second) preferences page
	 *              - No: return (first) user/password page
	 *          - No: return (first) user/password page
	 *  </pre>
	 *  @param request request
	 *  @param response response
	 *  @throws ServletException
	 *  @throws IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException
	{
		log.info("doPost");
		//  Create New Session
		HttpSession sess = request.getSession(true);
		sess.setMaxInactiveInterval(WebEnv.TIMEOUT);

		//  Get Cookie Properties
		Properties cProp = AWebUtil.getCookieProprties(request);

		//  Create Context
//		WebSessionCtx wsc = WebSessionCtx.get (request);
		WebSessionCtx wsc = WebSessionCtx.create (request);

		//  Page
		WebDoc doc = null;

		//  Check DB connection
		if (!DB.isConnected())
		{
			String msg = Msg.getMsg(wsc.ctx, "WLoginNoDB");
			if (msg.equals("WLoginNoDB"))
				msg = "No Database Connection";
			doc = WebDoc.createWindow (msg);
		}

		//  Login Info from request?
		else
		{
			//  Get Parameters:     UserName/Password
			String usr = WebUtil.getParameter (request, P_USERNAME);
			String pwd = WebUtil.getParameter (request, P_PASSWORD);
			//  Get Principle
			Principal userPrincipal = request.getUserPrincipal();
			log.info("Principal=" + userPrincipal + "; User=" + usr);

			//  Login info not from request and not pre-authorized
			if (userPrincipal == null && (usr == null || pwd == null))
				doc = createFirstPage (cProp, request, "");
			//  Login info from request or authorized
			else
			{
				KeyNamePair[] roles = null;
				Login login = new Login(wsc.ctx);
				//  Pre-authorized
				if (userPrincipal != null)
				{
					roles = login.getRoles(userPrincipal);
					usr = userPrincipal.getName();
				}
				else
					roles = login.getRoles(usr, pwd);
				//
				if (roles == null)
					doc = createFirstPage(cProp, request, Msg.getMsg(wsc.ctx, "UserPwdError"));
				else
				{
					doc = createSecondPage(request, WebUtil.convertToOption(roles, null), "");
					wsc.ctx.setContext(Env.LANGUAGE, WebUtil.getParameter (request, Env.LANGUAGE));
					//	Create Compiere Session - user id in ctx
					MSession.get (wsc.ctx, request.getRemoteAddr(), 
						request.getRemoteHost(), sess.getId() );
				}
				//  Can we save Cookie ?
				if (WebUtil.getParameter (request, P_STORE) == null)
				{
					cProp.clear();                          //  erase all
				}
				else    //  Save Cookie Parameter
				{
					cProp.setProperty(P_USERNAME, usr);
					cProp.setProperty(P_STORE, "Y");
					cProp.setProperty(P_PASSWORD, pwd);     //  For test only
					cProp.setProperty(Env.LANGUAGE, WebUtil.getParameter (request, Env.LANGUAGE));
				}
			}
		}
		//clmg test
		AWebUtil.writeDebugLog("main", doc.toString());
		//
		WebUtil.createResponse (request, response, this, cProp, doc, true);
	}	//	doPost

	//  Variable Names
	public  static final String     P_USERNAME      = "User";
	private static final String     P_PASSWORD      = "Password";
	private static final String     P_SUBMIT        = "Submit";
	//  WMenu picks it up
	public static final String   P_ROLE          = "AD_Role_ID";
	public static final String   P_CLIENT        = "AD_Client_ID";
	public static final String   P_ORG           = "AD_Org_ID";
	public static final String   P_DATE          = "Date";
	public static final String   P_WAREHOUSE     = "M_Warehouse_ID";
	protected static final String   P_ERRORMSG      = "ErrorMessage";
	protected static final String   P_STORE         = "SaveCookie";

	
	/**************************************************************************
	 *  First Login Page
	 *  @param cProp Login Cookie information for defaults
	 *  @param request request
	 *  @param errorMessage error message
	 *  @return WDoc page
	 */
	private WebDoc createFirstPage(Properties cProp, HttpServletRequest request,
		String errorMessage)
	{
		log.info ("createFirstPage - " + errorMessage);
		String AD_Language = (cProp.getProperty(Env.LANGUAGE, Language.getAD_Language(request.getLocale())));
		//
		String windowTitle = Msg.getMsg(AD_Language, "Login");
		String usrText = Msg.getMsg(AD_Language, "User");
		String pwdText = Msg.getMsg(AD_Language, "Password");
		String lngText = Msg.translate(AD_Language, "AD_Language");
//		String okText = Msg.getMsg(AD_Language, "OK");
//		String cancelText = Msg.getMsg(AD_Language, "Cancel");
		String okText = ("OK");//clmg 2009/03/04
		String cancelText = ("キャンセル");//clmg 2009/03/04
		String storeTxt = Msg.getMsg(AD_Language, "SaveCookie");

		//	Form - post to same URL
		String action = request.getRequestURI();
		form myForm = null;
		myForm = new form(action).setName("Login1");
		myForm.setName("Login1");
		table table = new table().setAlign(AlignType.CENTER);
		
//clmg 2009/01/22
		div divBody = (div)new div().setID("body"); //	<div id="body">
		div divLoginBox = (div)new div().setID("login-box"); //	<div id="login-box">		
		divBody.addElement(divLoginBox);
		
		div divInner = (div)new div().setClass("inner"); //	<div id="login">
		divLoginBox.addElement(divInner);
		divInner.addElement(myForm);
//--		

		//	Username
		String userData = cProp.getProperty(P_USERNAME, "");
		tr line = new tr();
		label usrLabel = new label().setFor(P_USERNAME + "F").addElement(usrText);
		usrLabel.setID(P_USERNAME + "L");
		line.addElement(new td().addElement(usrLabel).setAlign(AlignType.RIGHT));
		
		// input usr = new input(input.TYPE_TEXT, P_USERNAME, userData).setSize(20).setMaxlength(30);
		// Jirimuto modified 2008/10/24
		input usr = (input)(new input(input.TYPE_TEXT, P_USERNAME, userData));
		
		usr.setID(P_USERNAME + "F");
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(usr).setAlign(AlignType.LEFT));
		table.addElement(line);

		//  Password
		String pwdData = cProp.getProperty(P_PASSWORD, "");
		//clmg
		table.addElement(line);
		//
		line = new tr();
		label pwdLabel = new label().setFor(P_PASSWORD + "F").addElement(pwdText);
		pwdLabel.setID(P_PASSWORD + "L");
//		line.addElement(new td().addElement(pwdLabel).setAlign(AlignType.RIGHT));
		//clmg
		line.addElement(new td().addElement(pwdLabel).setAlign(AlignType.RIGHT));
		//
		// input pwd = new input(input.TYPE_PASSWORD, P_PASSWORD, pwdData).setSize(20).setMaxlength(30);
		// Jirimuto modified 2008/10/24
		input pwd = (input)(new input(input.TYPE_PASSWORD, P_PASSWORD, pwdData));
		pwd.setID(P_PASSWORD + "F");
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(pwd).setAlign(AlignType.LEFT));
		table.addElement(line);

		//	Language Pick
		//String langData = cProp.getProperty(AD_Language);
		//clmg
		table.addElement(line);
		//
		line = new tr();
		label langLabel = new label().setFor(Env.LANGUAGE.substring(1) + "F").addElement(lngText);
		langLabel.setID(Env.LANGUAGE.substring(1) + "L"); // #AD_LanguageF to AD_LanguageF
		line.addElement(new td().addElement(langLabel).setAlign(AlignType.RIGHT));
		option options[] = new option[Language.getLanguageCount()];
		for (int i = 0; i < Language.getLanguageCount(); i++)
		{
			Language language = Language.getLanguage(i);
			options[i] = new option(language.getAD_Language())
				.addElement(AmpiereUtil.maskHTML(language.getName()));
			if (language.getAD_Language().equals(AD_Language))
				options[i].setSelected(true);
			else
				options[i].setSelected(false);
		}
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(((select)(new select(Env.LANGUAGE, options)))
				.setID(Env.LANGUAGE.substring(1) + "F")));
		table.addElement(line);

		//  Store Cookie
		String storeData = cProp.getProperty(P_STORE, "N");
		line = new tr();
		//line.addElement(new td());
		input store = new input(input.TYPE_CHECKBOX, P_STORE, "Y").addElement(storeTxt).setChecked(storeData.equals("Y"));
		store.setID(P_STORE + "F");
		line.addElement(new td().addElement(store).setAlign(AlignType.LEFT));
		table.addElement(line);

		//  ErrorMessage
		if (errorMessage != null && errorMessage.length() > 0)
		{
			line = new tr();
			line.addElement(new td().setColSpan(2)
				.addElement(new font(HtmlColor.red, 4).addElement(new b(errorMessage))));   //  color, size
			table.addElement(line);
		}

		//  Finish
		//clmg
		table.addElement(line);
		line = new tr();
		div divButtonBox = (div)new div().setClass("button-box"); //	<div class="button-box">		
		
		input ok = new input(input.TYPE_SUBMIT, P_SUBMIT, okText);
		ok.setID("btn_submit");
		divButtonBox.addElement(ok);
		
		input cancel = new input(input.TYPE_RESET, "Reset", cancelText);
		cancel.setID("btn_reset");
		divButtonBox.addElement(cancel);
		
		line.addElement(new td().addElement(divButtonBox));
		table.addElement(line);
		//
	    
		myForm.addElement(table);
		
		//  Document
		//clmg, <div id="login"> 
		request.setAttribute(Constants.SECOND_DIV_ID, "login");
		//
		WebDoc doc = WebDoc.createWindow (windowTitle, request);
//		doc.addWindowCenter(true)
//			.addElement(new h3("The HTML UI is Beta Functionality!"))
//			.addElement(myForm);
		//clmg 2009/01/28
		doc.addWindowCenter(true)
//		.addElement(new h3("The HTML UI is Beta Functionality!"))
		.addElement(divBody);
		//--
		//  Clear Menu Frame
		doc.getBody()
			.addElement(WebUtil.getClearFrame(WebEnv.TARGET_MENU))
			.setTitle(windowTitle);


		return doc;
	}   //  createFirstPage


	/**
	 *  Create Second Page
	 *  @param request request
	 *  @param roleOptions role options
	 *  @param errorMessage error message
	 *  @return WDoc page
	 */
	private WebDoc createSecondPage(HttpServletRequest request,
		option[] roleOptions, String errorMessage)
	{
		log.info("createSecondPage - " + errorMessage);
		WebSessionCtx wsc = WebSessionCtx.get(request);
//		String windowTitle = Msg.getMsg(wsc.language, "LoginSuccess");
		String windowTitle = "職責選択"; //clmg 2009/03/04

		//  Create Document
		//clmg, <div id="login"> 
		request.setAttribute(Constants.SECOND_DIV_ID, "login");
		WebDoc doc = WebDoc.createWindow (windowTitle, request);
		//
		//WebDoc doc = WebDoc.createWindow (windowTitle);

		// For date picker
		AmpiereUtil.addDatePicker(doc.getHead(), wsc);

		//	Form - Get Menu
		String action = WebEnv.getBaseDirectory("WMenu");
		form myForm = null;
		myForm = new form(action).setName("Login2");
		myForm.setTarget(WebEnv.TARGET_MENU);
		table table = new table().setAlign(AlignType.CENTER);
		
		//clmg 2009/01/22
		div divBody = (div)new div().setID("body"); //	<div id="body">
		div divLoginBox = (div)new div().setID("login-box"); //	<div id="login-box">		
		divBody.addElement(divLoginBox);
		
		div divInner = (div)new div().setClass("inner"); //	<div id="login">
		divLoginBox.addElement(divInner);
		divInner.addElement(myForm);
//--			
		
		//	Role Pick
		tr line = new tr();
		label roleLabel = new label().setFor(P_ROLE + "F").addElement(Msg.translate(wsc.language, "AD_Role_ID"));
		roleLabel.setID(P_ROLE + "L");
		line.addElement(new td().addElement(roleLabel).setAlign(AlignType.RIGHT).setWidth(220));
		select role = (select)(new select(P_ROLE, roleOptions));
		role.setClass("w240"); //clmg 
		role.setID(P_ROLE + "F");
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(role));
		table.addElement(line);
		table.setWidth(500);

		// : /compiere/ampiere/WLoginAjaxAction.do?role=102
		StringBuffer sbRoleAjaxScript = new StringBuffer()
		.append(AjaxJavascriptParts.makeAjaxAmpiereMutiUpdate(
				WebEnv.getBaseDirectory("WLoginAjaxAction.do"), //URL
				P_ROLE+"F", //Sourc ID
				null, //use default parser 
				true, //report error
				null, //no call function
				null, //no call after
				"role", //web param name
				null, //no web ather param
				null //use default event change
				));
		

		//	Client Pick
		line = new tr();
		label clientLabel = new label().setFor(P_CLIENT + "F").addElement(Msg.translate(wsc.language, "AD_Client_ID"));
		clientLabel.setID(P_CLIENT + "L");
		line.addElement(new td().addElement(clientLabel).setAlign(AlignType.RIGHT));
		select client = (select)(new select(P_CLIENT));
		client.setID(P_CLIENT + "F");
		client.setClass("w240"); //clmg 
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(client));
		table.addElement(line);


		// : /compiere/ampiere/WLoginAjaxAction.do?client=1
		StringBuffer sbClientAjaxScript = new StringBuffer()
		.append(AjaxJavascriptParts.makeAjaxAmpiereMutiUpdate(
				WebEnv.getBaseDirectory("WLoginAjaxAction.do"), //URL
				P_CLIENT+"F", //Sourc ID
				null, //use default parser 
				true, //report error
				null, //no call function
				null, //no call after
				"client", //web param name
				null, //no web ather param
				null //use default event change
				));

		//	Org Pick
		line = new tr();
		label orgLabel = new label().setFor(P_ORG + "F").addElement(Msg.translate(wsc.language, "AD_Org_ID"));
		orgLabel.setID(P_ORG + "L");
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(orgLabel).setAlign(AlignType.RIGHT));
		select org = (select)(new select(P_ORG));
		org.setID(P_ORG + "F");
		org.setClass("w240"); //clmg 
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(org));
		table.addElement(line);

		// : /compiere/ampiere/WLoginAjaxAction.do?org=102
		StringBuffer sbOrgAjaxScript = new StringBuffer()
		.append(AjaxJavascriptParts.makeAjaxAmpiereMutiUpdate(
				WebEnv.getBaseDirectory("WLoginAjaxAction.do"), //URL
				P_ORG+"F", //Sourc ID
				null, //use default parser 
				true, //report error
				null, //no call function
				null, //no call after
				"org", //web param name
				null, //no web ather param
				null //use default event change
				));

		//  Warehouse
		line = new tr();
		label whLabel = new label().setFor(P_WAREHOUSE + "F").addElement(Msg.translate(wsc.language, "M_Warehouse_ID"));
		whLabel.setID(P_WAREHOUSE + "L");
		line.addElement(new td().addElement(whLabel).setAlign(AlignType.RIGHT));
		select wh = (select)(new select(P_WAREHOUSE));
		wh.setID(P_WAREHOUSE + "F");
		wh.setClass("w240"); //clmg 
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(wh ));
		table.addElement(line);

		//  Date
		String dateData = wsc.dateFormat.format(new java.util.Date());
		line = new tr();
		label dateLabel = new label().setFor(P_DATE + "F").addElement(Msg.getMsg(wsc.language, "Date"));
		dateLabel.setID(P_DATE + "L");
		line.addElement(new td().addElement(dateLabel).setAlign(AlignType.RIGHT));
		// input date = new input(input.TYPE_TEXT, P_DATE, dateData).setSize(14).setMaxlength(10);
		// Jirimuto modified 2008/10/24
		input date = (input)(new input(input.TYPE_TEXT, P_DATE, dateData));
		date.setID(P_DATE + "F");
		date.setOnChange("checkDateValidation(this, paraInvalidDateMsg);");

		// Add date picker
		String png = "Calendar16.png"; //clmg, use png
		img button = new img(WebEnv.getImageDirectory(png), P_DATE + "P");
		button.setID(P_DATE + "P");
		button.setClass("popupButton");
		
		//clmg 2009/03/08
//		String onClick = "recDate_onclick_function('" + P_DATE + "F" + "', null, paraMonths, paraShortMonths, paraWeeks, paraShortWeeks, paraDateFormat);";
//		button.setOnClick(onClick + "return false;");
		
		div dateTimePickerScriptDiv = new div();//clmg 2009/03/08
		String inputBoxId = P_DATE + "F";
		String buttonId = P_DATE + "P";
		AmpiereUtil.addDatePickerScript(dateTimePickerScriptDiv, inputBoxId, buttonId);	


		date.addElement(button);
		//clmg 2009/03/08
		date.addElement(dateTimePickerScriptDiv);
		
		//clmg
		table.addElement(line);
		line = new tr();
		//
		line.addElement(new td().addElement(date).setAlign(AlignType.LEFT));

		table.addElement(line);

		//  ErrorMessage
		if (errorMessage != null && errorMessage.length() > 0)
		{
			line = new tr();
			line.addElement(new td().addElement(new strong(errorMessage)).setColSpan(2).setAlign(AlignType.CENTER));
			table.addElement(line);
		}

		//  Finish
		line = new tr();
		//clmg
		div divButtonBox = (div)new div().setClass("button-box"); //	<div class="button-box">	
		//
//		input submit = new input(input.TYPE_SUBMIT, "Submit", Msg.getMsg(wsc.language, "OK"));
		input submit = new input(input.TYPE_SUBMIT, "Submit", "OK"); //clmg 2009/03/04
		submit.setOnClick("showLoadingMenu('" + WebEnv.getBaseDirectory("") + "');");
		submit.setID("btn_submit");
		divButtonBox.addElement(submit);
		
//		input cancel = new input(input.TYPE_RESET, "Reset", Msg.getMsg(wsc.language, "Cancel"));
		input cancel = new input(input.TYPE_RESET, "Reset", "キャンセル");
		divButtonBox.addElement(cancel);
		cancel.setID("btn_reset");
		line.addElement(new td().addElement(divButtonBox)); //clmg
		table.addElement(line);
		//
		myForm.addElement(table);

		AjaxJavascriptParts.addAjaxHeader(doc.getHead(),false,false);
		doc.addWindowCenter(true)
			//.addElement(new h3("The HTML UI is Powered by ALMAS Beta Functionality!"))
			//.addElement(myForm);//replace to divBody
			.addElement(divBody);//
		//
		String scriptGlobalProgress = //"fieldUpdate(document.Login2." + P_ROLE + ");";	//  init dependency updates
			AjaxJavascriptParts.makeAjaxProgressScript(WebEnv.PROGRESS_ID);
		String script = //"fieldUpdate(document.Login2." + P_ROLE + ");";	//  init dependency updates
			"$('"+P_ROLE+"F"+"').onchange();";
		body bdy = doc.getBody();
		bdy.addElement(new script(sbRoleAjaxScript.toString()));
		bdy.addElement(new script(sbClientAjaxScript.toString()));
		bdy.addElement(new script(sbOrgAjaxScript.toString()));
		bdy.addElement(new script(scriptGlobalProgress));
		bdy.addElement(new script(script));
		
		//  Note
		doc.addWindowFooter()
			.addElement(new p(Msg.getMsg(wsc.language, "WLoginBrowserNote"), AlignType.CENTER));


		return doc;
	}   //  createSecondPage

}	//	WLogin
