/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.TextDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadConfiguration;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class BeanRuleSet
implements RuleSet {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$BeanRuleSet == null ? (class$org$apache$commons$betwixt$io$BeanRuleSet = BeanRuleSet.class$("org.apache.commons.betwixt.io.BeanRuleSet")) : class$org$apache$commons$betwixt$io$BeanRuleSet));
    private XMLIntrospector introspector;
    private String basePath;
    private ElementDescriptor baseElementDescriptor;
    private Class baseBeanClass;
    private ReadContext baseContext;
    private String classNameAttribute = "className";
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanRuleSet;
    static /* synthetic */ Class class$java$util$Map;

    public static void setLog(Log aLog) {
        log = aLog;
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Class baseBeanClass, boolean matchIDs) {
        this.introspector = introspector;
        this.basePath = basePath;
        this.baseElementDescriptor = baseElementDescriptor;
        this.baseBeanClass = baseBeanClass;
        BindingConfiguration bindingConfiguration = new BindingConfiguration();
        bindingConfiguration.setMapIDs(matchIDs);
        this.baseContext = new ReadContext(log, bindingConfiguration, new ReadConfiguration());
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Class baseBeanClass, Context context) {
        this.introspector = introspector;
        this.basePath = basePath;
        this.baseElementDescriptor = baseElementDescriptor;
        this.baseBeanClass = baseBeanClass;
        this.baseContext = new ReadContext(context, new ReadConfiguration());
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Class baseBeanClass, ReadContext baseContext) {
        this.introspector = introspector;
        this.basePath = basePath;
        this.baseElementDescriptor = baseElementDescriptor;
        this.baseBeanClass = baseBeanClass;
        this.baseContext = baseContext;
    }

    public String getClassNameAttribute() {
        return this.baseContext.getClassNameAttribute();
    }

    public void setClassNameAttribute(String classNameAttribute) {
        this.baseContext.setClassNameAttribute(classNameAttribute);
    }

    public String getNamespaceURI() {
        return null;
    }

    public void addRuleInstances(Digester digester) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding rules to:" + digester));
        }
        ReadingContext readContext = new ReadingContext(digester);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReadingContext {
        private Map rulesByPath = new HashMap();

        ReadingContext(Digester digester) {
            ReadContext context = new ReadContext(BeanRuleSet.this.baseContext);
            if (context.getClassLoader() == null) {
                context.setClassLoader(digester.getClassLoader());
            }
            BeanRule rule = new BeanRule(BeanRuleSet.this.basePath + "/", BeanRuleSet.this.baseElementDescriptor, BeanRuleSet.this.baseBeanClass, context);
            this.addRule(BeanRuleSet.this.basePath, rule, BeanRuleSet.this.baseElementDescriptor, context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added root rule to path: " + BeanRuleSet.this.basePath + " class: " + BeanRuleSet.this.baseBeanClass));
            }
            Iterator it = this.rulesByPath.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Added rule:" + entry.getValue() + " @path:" + entry.getKey()));
                }
                digester.addRule((String)entry.getKey(), (Rule)entry.getValue());
            }
        }

        private void addChildRules(String prefix, ElementDescriptor currentDescriptor, ReadContext context) {
            ElementDescriptor typeDescriptor;
            ElementDescriptor[] childDescriptors;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding child rules for " + currentDescriptor + "@" + prefix));
            }
            if ((childDescriptors = (typeDescriptor = this.getElementDescriptor(currentDescriptor)).getElementDescriptors()) != null) {
                int size = childDescriptors.length;
                for (int i = 0; i < size; ++i) {
                    String qualifiedName;
                    ElementDescriptor childDescriptor = childDescriptors[i];
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Processing child " + childDescriptor));
                    }
                    if ((qualifiedName = childDescriptor.getQualifiedName()) == null) {
                        log.trace((Object)"Ignoring");
                        continue;
                    }
                    String path = prefix + qualifiedName;
                    if (qualifiedName.equals(currentDescriptor.getQualifiedName()) && currentDescriptor.getPropertyName() != null) {
                        log.trace((Object)"Creating generic rule for recursive elements");
                        int index = -1;
                        if (childDescriptor.isWrapCollectionsInElement()) {
                            index = prefix.indexOf(qualifiedName);
                            if (index == -1) {
                                log.debug((Object)"Oops - this shouldn't happen");
                                continue;
                            }
                            int removeSlash = prefix.endsWith("/") ? 1 : 0;
                            path = "*/" + prefix.substring(index, prefix.length() - removeSlash);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Added wrapped rule for " + childDescriptor));
                            }
                        } else {
                            ElementDescriptor[] desc = currentDescriptor.getElementDescriptors();
                            if (desc.length == 1) {
                                path = "*/" + desc[0].getQualifiedName();
                            }
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Added not wrapped rule for " + childDescriptor));
                            }
                        }
                        this.addRule(path, childDescriptor, context);
                        continue;
                    }
                    if (childDescriptor.getUpdater() != null) {
                        if (log.isTraceEnabled() && childDescriptor.getUpdater() instanceof MethodUpdater) {
                            log.trace((Object)("Element has updater " + ((MethodUpdater)childDescriptor.getUpdater()).getMethod().getName()));
                        }
                        if (childDescriptor.isPrimitiveType()) {
                            this.addPrimitiveTypeRule(path, childDescriptor, context);
                        } else {
                            Class beanClass;
                            ElementDescriptor grandChild;
                            String grandChildQName;
                            ElementDescriptor[] grandChildren = childDescriptor.getElementDescriptors();
                            if (grandChildren != null && grandChildren.length > 0 && (grandChildQName = (grandChild = grandChildren[0]).getQualifiedName()) != null && grandChildQName.length() > 0) {
                                if (childDescriptor.isWrapCollectionsInElement()) {
                                    path = path + '/' + grandChildQName;
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)("Descriptor wraps elements in collection, path:" + path));
                                    }
                                } else {
                                    path = prefix + (prefix.endsWith("/") ? "" : "/") + grandChildQName;
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)("Descriptor does not wrap elements in collection, path:" + path));
                                    }
                                }
                            }
                            if (XMLIntrospectorHelper.isPrimitiveType(beanClass = childDescriptor.getSingularPropertyType())) {
                                this.addPrimitiveTypeRule(path, childDescriptor, context);
                            } else {
                                this.addRule(path, childDescriptor, context);
                            }
                        }
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)("Element does not have updater: " + childDescriptor));
                    }
                    ElementDescriptor[] grandChildren = childDescriptor.getElementDescriptors();
                    if (grandChildren != null && grandChildren.length > 0) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Adding grand children @path:" + path));
                        }
                        this.addChildRules(path + '/', childDescriptor, context);
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("No children for " + childDescriptor));
                }
            }
        }

        ElementDescriptor getElementDescriptor(ElementDescriptor propertyDescriptor) {
            Class beanClass = propertyDescriptor.getSingularPropertyType();
            if (beanClass != null && !(class$java$util$Map == null ? (class$java$util$Map = BeanRuleSet.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(beanClass)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Filling descriptor for: " + beanClass));
                }
                try {
                    XMLBeanInfo xmlInfo = BeanRuleSet.this.introspector.introspect(beanClass);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Is wrapped? " + xmlInfo.getElementDescriptor().isWrapCollectionsInElement()));
                    }
                    return xmlInfo.getElementDescriptor();
                }
                catch (Exception e) {
                    log.warn((Object)("Could not introspect class: " + beanClass), (Throwable)e);
                }
            }
            return propertyDescriptor;
        }

        void addPrimitiveTypeRule(String path, ElementDescriptor childDescriptor, ReadContext context) {
            Rule rule = new Rule(this, childDescriptor, context){
                private final /* synthetic */ ElementDescriptor val$childDescriptor;
                private final /* synthetic */ ReadContext val$context;
                private final /* synthetic */ ReadingContext this$1;
                {
                    this.this$1 = this$1;
                    this.val$childDescriptor = val$childDescriptor;
                    this.val$context = val$context;
                }

                public void body(String text) throws Exception {
                    this.val$childDescriptor.getUpdater().update(this.val$context, text);
                }
            };
            this.add(path, rule);
        }

        private void addRule(String path, ElementDescriptor elementDescriptor, ReadContext context) {
            BeanRule rule = new BeanRule(path + '/', elementDescriptor, context);
            this.addRule(path, rule, elementDescriptor, context);
        }

        private void addRule(String path, Rule rule, ElementDescriptor elementDescriptor, ReadContext context) {
            if (this.add(path, rule)) {
                this.addChildRules(path + '/', elementDescriptor, context);
            }
        }

        private boolean add(String path, Rule rule) {
            if (!this.rulesByPath.containsKey(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added rule for path: " + path + " rule: " + rule));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)this.rulesByPath);
                    }
                }
                this.rulesByPath.put(path, rule);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring duplicate digester rule for path: " + path + " rule: " + rule));
                log.debug((Object)("New rule (not added): " + rule));
                log.debug((Object)("Existing rule:" + this.rulesByPath.get(path)));
            }
            return false;
        }

        private class BeanRule
        extends Rule {
            private ElementDescriptor descriptor;
            private ReadContext context;
            private boolean createdBean;
            private Class beanClass;
            private String pathPrefix;

            public BeanRule(ElementDescriptor descriptor, Class beanClass, ReadContext context) {
                this(descriptor.getQualifiedName() + "/", descriptor, beanClass, context);
            }

            public BeanRule(String pathPrefix, ElementDescriptor descriptor, ReadContext context) {
                this(pathPrefix, descriptor, descriptor.getSingularPropertyType(), context);
            }

            private BeanRule(String pathPrefix, ElementDescriptor descriptor, Class beanClass, ReadContext context) {
                this.descriptor = descriptor;
                this.context = context;
                this.beanClass = beanClass;
                this.pathPrefix = pathPrefix;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Created bean create rule");
                    log.trace((Object)("Descriptor=" + descriptor));
                    log.trace((Object)("Class=" + beanClass));
                    log.trace((Object)("Path prefix=" + pathPrefix));
                }
            }

            public void begin(String namespace, String name, Attributes attributes) {
                log.debug((Object)("Called with descriptor: " + this.descriptor + " propertyType: " + this.descriptor.getPropertyType()));
                if (log.isTraceEnabled()) {
                    int attributesLength = attributes.getLength();
                    if (attributesLength > 0) {
                        log.trace((Object)"Attributes:");
                    }
                    int size = attributesLength;
                    for (int i = 0; i < size; ++i) {
                        log.trace((Object)("Local:" + attributes.getLocalName(i)));
                        log.trace((Object)("URI:" + attributes.getURI(i)));
                        log.trace((Object)("QName:" + attributes.getQName(i)));
                    }
                }
                this.createdBean = false;
                Object instance = null;
                if (this.beanClass != null && (instance = this.createBean(namespace, name, attributes)) != null) {
                    String id;
                    this.createdBean = true;
                    this.context.setBean(instance);
                    this.digester.push(instance);
                    ElementDescriptor typeDescriptor = ReadingContext.this.getElementDescriptor(this.descriptor);
                    AttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributeDescriptors();
                    if (attributeDescriptors != null) {
                        int size = attributeDescriptors.length;
                        for (int i = 0; i < size; ++i) {
                            AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                            String value = attributes.getValue(attributeDescriptor.getURI(), attributeDescriptor.getLocalName());
                            if (value == null) {
                                value = attributes.getValue(attributeDescriptor.getQualifiedName());
                            }
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Attr URL:" + attributeDescriptor.getURI()));
                                log.trace((Object)("Attr LocalName:" + attributeDescriptor.getLocalName()));
                                log.trace((Object)value);
                            }
                            Updater updater = attributeDescriptor.getUpdater();
                            log.trace((Object)updater);
                            if (updater == null || value == null) continue;
                            updater.update(this.context, value);
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Created bean " + instance));
                        log.trace((Object)("Path prefix: " + this.pathPrefix));
                    }
                    if (this.context.getMapIDs() && (id = attributes.getValue("id")) != null) {
                        this.context.putBean(id, instance);
                    }
                }
            }

            public void body(String namespace, String name, String text) {
                log.trace((Object)("Body with text " + text));
                if (this.digester.getCount() > 0) {
                    Context bodyContext = this.context.newContext(this.digester.peek());
                    ElementDescriptor typeDescriptor = ReadingContext.this.getElementDescriptor(this.descriptor);
                    TextDescriptor descriptor = typeDescriptor.getPrimaryBodyTextDescriptor();
                    if (descriptor != null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Setting mixed content for:");
                            log.trace((Object)descriptor);
                        }
                        Updater updater = descriptor.getUpdater();
                        log.trace((Object)"Updating mixed content with:");
                        log.trace((Object)updater);
                        if (updater != null && text != null) {
                            updater.update(bodyContext, text);
                        }
                    }
                }
            }

            public void end() {
                if (this.createdBean) {
                    Updater updater = this.descriptor.getUpdater();
                    Object instance = this.context.getBean();
                    Object top = this.digester.pop();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Popped " + top));
                    }
                    if (this.digester.getCount() == 0) {
                        this.context.setBean(null);
                    } else {
                        this.context.setBean(this.digester.peek());
                    }
                    if (updater != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Calling updater for: " + this.descriptor + " with: " + instance + " on bean: " + this.context.getBean()));
                        }
                        updater.update(this.context, instance);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("No updater for: " + this.descriptor + " with: " + instance + " on bean: " + this.context.getBean()));
                    }
                }
            }

            public void finish() {
                BeanRuleSet.this.baseContext.clearBeans();
            }

            protected Object createBean(String namespace, String name, Attributes attributes) {
                ElementMapping mapping = new ElementMapping();
                mapping.setType(this.beanClass);
                mapping.setNamespace(namespace);
                mapping.setName(name);
                mapping.setAttributes(attributes);
                mapping.setDescriptor(this.descriptor);
                Object newInstance = this.context.getBeanCreationChain().create(mapping, this.context);
                return newInstance;
            }

            public String toString() {
                return "BeanRule [path prefix=" + this.pathPrefix + " descriptor=" + this.descriptor + "]";
            }
        }
    }
}

