/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    protected PRTokeniser tokens;
    protected int[] xref;
    protected PdfObject[] xrefObj;
    protected PdfDictionary trailer;
    protected PdfDictionary[] pages;
    protected PdfDictionary catalog;
    protected PRIndirectReference[] pageRefs;
    protected PRAcroForm acroForm = null;
    protected ArrayList pageInh;
    protected int pagesCount;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;

    public PdfReader(String string) throws IOException {
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        return this.acroForm;
    }

    public int getPageRotation(int n) {
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfNumber pdfNumber = (PdfNumber)this.getPdfObject(pdfDictionary.get(PdfName.ROTATE));
        if (pdfNumber == null) {
            return 0;
        }
        return pdfNumber.intValue();
    }

    public Rectangle getPageSizeWithRotation(int n) {
        Rectangle rectangle = this.getPageSize(n);
        int n2 = this.getPageRotation(n);
        while (n2 > 0) {
            rectangle = rectangle.rotate();
            n2 -= 90;
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n) {
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfArray pdfArray = (PdfArray)this.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getCropBox(int n) {
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfArray pdfArray = (PdfArray)this.getPdfObject(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(n);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public HashMap getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = (PdfDictionary)this.getPdfObject(this.trailer.get(PdfName.INFO));
        if (pdfDictionary == null) {
            return hashMap;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = this.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    byte[] byArray = PdfEncodings.convertToBytes(string, null);
                    if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                        string = PdfEncodings.convertToString(byArray, "UnicodeBig");
                        break;
                    }
                    string = PdfEncodings.convertToString(byArray, "PDF");
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        ArrayList arrayList = pdfArray.getArrayList();
        float f = ((PdfNumber)arrayList.get(0)).floatValue();
        float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
        float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
        float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
        return new Rectangle(Math.min(f, f3), Math.min(f2, f4), Math.max(f, f3), Math.max(f2, f4));
    }

    protected void readPdf() throws IOException {
        try {
            this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                if (this.encrypted) {
                    throw (IOException)exception;
                }
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            this.readDocObj();
            this.readPages();
            PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
            if (pdfObject != null) {
                this.acroForm = new PRAcroForm(this);
                this.acroForm.readAcroForm((PdfDictionary)this.getPdfObject(pdfObject));
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
    }

    public PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject.type() != 10) {
            return pdfObject;
        }
        int n = ((PRIndirectReference)pdfObject).getNumber();
        if ((pdfObject = this.xrefObj[n]) == null) {
            return PdfNull.PDFNULL;
        }
        return pdfObject;
    }

    protected void pushPageAttributes(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (this.pageInh.size() != 0) {
            pdfDictionary2.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        int n = 0;
        while (n < pageInhCandidates.length) {
            PdfObject pdfObject = pdfDictionary.get(pageInhCandidates[n]);
            if (pdfObject != null) {
                pdfDictionary2.put(pageInhCandidates[n], pdfObject);
            }
            ++n;
        }
        this.pageInh.add(pdfDictionary2);
    }

    protected void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    protected void iteratePages(PdfDictionary pdfDictionary) throws IOException {
        PdfName pdfName = (PdfName)this.getPdfObject(pdfDictionary.get(PdfName.TYPE));
        if (pdfName.equals(PdfName.PAGE)) {
            PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
            Iterator iterator = pdfDictionary2.getKeys().iterator();
            while (iterator.hasNext()) {
                PdfName pdfName2 = (PdfName)iterator.next();
                if (pdfDictionary.get(pdfName2) != null) continue;
                pdfDictionary.put(pdfName2, pdfDictionary2.get(pdfName2));
            }
            this.pages[this.pagesCount++] = pdfDictionary;
        } else {
            this.pushPageAttributes(pdfDictionary);
            PdfArray pdfArray = (PdfArray)this.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            ArrayList arrayList = pdfArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                this.pageRefs[this.pagesCount] = (PRIndirectReference)arrayList.get(n);
                PdfDictionary pdfDictionary3 = (PdfDictionary)this.getPdfObject(this.pageRefs[this.pagesCount]);
                this.iteratePages(pdfDictionary3);
                ++n;
            }
            this.popPageAttributes();
        }
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)this.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary pdfDictionary = (PdfDictionary)this.getPdfObject(this.catalog.get(PdfName.PAGES));
        PdfNumber pdfNumber = (PdfNumber)this.getPdfObject(pdfDictionary.get(PdfName.COUNT));
        this.pages = new PdfDictionary[pdfNumber.intValue()];
        this.pageRefs = new PRIndirectReference[this.pages.length];
        this.pagesCount = 0;
        this.iteratePages(pdfDictionary);
        this.pageInh = null;
    }

    protected void readDocObj() throws IOException {
        int n;
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.xrefObj = new PdfObject[this.xref.length];
        int n2 = 1;
        while (n2 < this.xrefObj.length) {
            n = this.xref[n2];
            if (n > 0) {
                PdfObject pdfObject;
                this.tokens.seek(n);
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid object number.");
                }
                int n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid generation number.");
                }
                int n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (!this.tokens.getStringValue().equals("obj")) {
                    this.tokens.throwError("Token 'obj' expected.");
                }
                this.xrefObj[n2] = pdfObject = this.readPRObject();
                if (pdfObject.type() == 7) {
                    arrayList.add(pdfObject);
                }
            }
            ++n2;
        }
        n = 0;
        while (n < arrayList.size()) {
            PRStream pRStream = (PRStream)arrayList.get(n);
            PdfObject pdfObject = this.getPdfObject(pRStream.get(PdfName.LENGTH));
            pRStream.setLength(((PdfNumber)pdfObject).intValue());
            ++n;
        }
    }

    protected void readXref() throws IOException {
        PdfNumber pdfNumber;
        int n;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        int n2 = this.tokens.intValue();
        this.tokens.seek(n2);
        while ((n = this.tokens.read()) != -1 && n != 116) {
        }
        if (n == -1) {
            throw new IOException("Unexpected end of file.");
        }
        this.tokens.backOnePosition();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("trailer")) {
            throw new IOException("trailer not found.");
        }
        this.trailer = (PdfDictionary)this.readPRObject();
        if (this.trailer.get(PdfName.ENCRYPT) != null) {
            this.encrypted = true;
            throw new IOException("Encrypted files are not supported.");
        }
        PdfNumber pdfNumber2 = (PdfNumber)this.trailer.get(PdfName.SIZE);
        this.xref = new int[pdfNumber2.intValue()];
        this.tokens.seek(n2);
        this.readXrefSection();
        PdfDictionary pdfDictionary = this.trailer;
        while ((pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.PREV)) != null) {
            this.tokens.seek(pdfNumber.intValue());
            this.readXrefSection();
            pdfDictionary = (PdfDictionary)this.readPRObject();
        }
    }

    protected void readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0: while (true) {
            int n5;
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n2 = this.tokens.intValue() + n;
            if (n == 1) {
                n5 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                if (n3 == 0 && n4 == 65535) {
                    --n;
                    --n2;
                }
                this.tokens.seek(n5);
            }
            if (this.xref.length < n2) {
                int[] nArray = new int[n2];
                System.arraycopy(this.xref, 0, nArray, 0, this.xref.length);
                this.xref = nArray;
            }
            n5 = n;
            while (true) {
                if (n5 >= n2) continue block0;
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n5] == 0) {
                        this.xref[n5] = n3;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n5] == 0) {
                        this.xref[n5] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n5;
            }
            break;
        }
    }

    protected void rebuildXref() throws IOException {
        Object object;
        int n;
        this.tokens.seek(0);
        int[][] nArrayArray = new int[1024][];
        Object object2 = 0;
        this.trailer = null;
        byte[] byArray = new byte[64];
        while (true) {
            n = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(byArray)) break;
            if (byArray[0] == 116) {
                if (!PdfEncodings.convertToString(byArray, null).startsWith("trailer")) continue;
                n = this.tokens.getFilePointer();
                try {
                    object = (PdfDictionary)this.readPRObject();
                    if (object.get(PdfName.ROOT) != null) {
                        this.trailer = object;
                        continue;
                    }
                    this.tokens.seek(n);
                }
                catch (Exception exception) {
                    this.tokens.seek(n);
                }
                continue;
            }
            if (byArray[0] < 48 || byArray[0] > 57 || (object = PRTokeniser.checkObjectStart(byArray)) == null) continue;
            Object object3 = object[0];
            Object object4 = object[1];
            if (object3 >= nArrayArray.length) {
                reference var8_9 = object3 * 2;
                int[][] nArrayArray2 = new int[var8_9][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, object2);
                nArrayArray = nArrayArray2;
            }
            if (object3 >= object2) {
                object2 = object3 + true;
            }
            if (nArrayArray[object3] != null && object4 < nArrayArray[object3][1]) continue;
            object[0] = n;
            nArrayArray[object3] = object;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        if (this.trailer.get(PdfName.ENCRYPT) != null) {
            throw new IOException("Encrypted files are not supported.");
        }
        this.xref = new int[object2];
        n = 0;
        while (n < object2) {
            object = nArrayArray[n];
            if (object != null) {
                this.xref[n] = (int)object[0];
            }
            ++n;
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue());
            PdfObject pdfObject = this.readPRObject();
            int n = pdfObject.type();
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n;
        PdfArray pdfArray = new PdfArray();
        while (-(n = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n = this.tokens.getTokenType();
        switch (n) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                int n2 = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int n3 = this.tokens.read();
                    if (n3 == 13) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition();
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    return pRStream;
                }
                this.tokens.seek(n2);
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                return new PdfString(this.tokens.getStringValue(), null);
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                return new PRIndirectReference(this, this.tokens.getReference(), this.tokens.getGeneration());
            }
        }
        return new PdfLiteral(-n, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n;
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 == 62) break;
            if (!PRTokeniser.isWhitespace(n3)) {
                int n4 = PRTokeniser.getHex(n3);
                if (n4 == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (bl) {
                    n = n4;
                } else {
                    byteArrayOutputStream.write((byte)((n << 4) + n4));
                }
                bl = !bl;
            }
            ++n2;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int[] nArray = new int[5];
        int n3 = 0;
        while (n3 < byArray.length) {
            n = byArray[n3] & 0xFF;
            if (n == 126) break;
            if (!PRTokeniser.isWhitespace(n)) {
                if (n == 122 && n2 == 0) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                } else {
                    if (n < 33 || n > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    nArray[n2] = n - 33;
                    if (++n2 == 5) {
                        n2 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < 5) {
                            n4 = n4 * 85 + nArray[n5];
                            ++n5;
                        }
                        byteArrayOutputStream.write((byte)(n4 >> 24));
                        byteArrayOutputStream.write((byte)(n4 >> 16));
                        byteArrayOutputStream.write((byte)(n4 >> 8));
                        byteArrayOutputStream.write((byte)n4);
                    }
                }
            }
            ++n3;
        }
        n = 0;
        if (n2 == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (n2 == 2) {
            n = nArray[0] * 85 + nArray[1];
            byteArrayOutputStream.write((byte)n);
        } else if (n2 == 3) {
            n = nArray[0] * 85 * 85 + nArray[1] * 85 + nArray[2];
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        } else if (n2 == 4) {
            n = nArray[0] * 85 * 85 * 85 + nArray[1] * 85 * 85 + nArray[2] * 85 + nArray[3];
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int n) {
        if (n > this.pages.length) {
            return null;
        }
        return this.pages[n - 1];
    }

    public PRIndirectReference getPageOrigRef(int n) {
        if (n > this.pageRefs.length) {
            return null;
        }
        return this.pageRefs[n - 1];
    }
}

