/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.IOutputSegment;
import au.id.jericho.lib.html.OverlappingOutputSegmentsException;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class OutputDocument {
    private CharSequence sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(CharSequence charSequence) {
        if (charSequence == null) {
            throw new IllegalArgumentException();
        }
        this.sourceText = charSequence;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void add(IOutputSegment iOutputSegment) {
        this.outputSegments.add(iOutputSegment);
    }

    public void add(FormControl formControl) {
        formControl.addToOutputDocument(this);
    }

    public void add(FormFields formFields) {
        formFields.addToOutputDocument(this);
    }

    public void output(Writer writer) throws IOException {
        if (this.outputSegments.isEmpty()) {
            Util.appendTo(writer, this.sourceText);
            return;
        }
        int n = 0;
        Collections.sort(this.outputSegments, IOutputSegment.COMPARATOR);
        IOutputSegment iOutputSegment = null;
        Iterator iterator = this.outputSegments.iterator();
        while (iterator.hasNext()) {
            IOutputSegment iOutputSegment2 = (IOutputSegment)iterator.next();
            if (iOutputSegment2 == iOutputSegment) continue;
            if (iOutputSegment2.getBegin() < n) {
                throw new OverlappingOutputSegmentsException(iOutputSegment, iOutputSegment2);
            }
            if (iOutputSegment2.getBegin() > n) {
                Util.appendTo(writer, this.sourceText, n, iOutputSegment2.getBegin());
            }
            iOutputSegment2.output(writer);
            iOutputSegment = iOutputSegment2;
            n = iOutputSegment2.getEnd();
        }
        if (n < this.sourceText.length()) {
            Util.appendTo(writer, this.sourceText, n, this.sourceText.length());
        }
        writer.close();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter((int)((double)this.sourceText.length() * 1.5));
        try {
            this.output(stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }
}

