/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormControlType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public final class FormField {
    private String name;
    private int userValueCount = 0;
    private boolean allowsMultipleValues = false;
    private LinkedHashSet predefinedValues = null;
    private LinkedHashSet formControls = new LinkedHashSet();
    private transient FormControl firstFormControl = null;
    protected int columnIndex;

    FormField(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getUserValueCount() {
        return this.userValueCount;
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public Collection getPredefinedValues() {
        return this.predefinedValues != null ? this.predefinedValues : Collections.EMPTY_SET;
    }

    public Collection getFormControls() {
        return this.formControls;
    }

    public void clearValues() {
        Iterator iterator = this.formControls.iterator();
        while (iterator.hasNext()) {
            ((FormControl)iterator.next()).clearValues();
        }
    }

    public Collection getValues() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.formControls.iterator();
        while (iterator.hasNext()) {
            ((FormControl)iterator.next()).addValuesTo(hashSet);
        }
        return hashSet;
    }

    public void setValues(Collection collection) {
        this.clearValues();
        this.addValues(collection);
    }

    public boolean setValue(CharSequence charSequence) {
        this.clearValues();
        return this.addValue(charSequence);
    }

    public boolean addValue(CharSequence charSequence) {
        FormControl formControl;
        LinkedList<FormControl> linkedList = null;
        Iterator iterator = this.formControls.iterator();
        while (iterator.hasNext()) {
            formControl = (FormControl)iterator.next();
            if (this.formControls.size() > 1 && !formControl.getFormControlType().isPredefinedValue()) {
                if (linkedList == null) {
                    linkedList = new LinkedList<FormControl>();
                }
                linkedList.add(formControl);
                continue;
            }
            if (!formControl.addValue(charSequence)) continue;
            return true;
        }
        if (linkedList == null) {
            return false;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            formControl = (FormControl)iterator.next();
            if (!formControl.addValue(charSequence)) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Field: ").append(this.name).append(", UserValueCount=").append(this.userValueCount).append(", AllowsMultipleValues=").append(this.allowsMultipleValues);
        if (this.predefinedValues != null) {
            iterator = this.predefinedValues.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\nPredefinedValue: ");
                stringBuffer.append(iterator.next());
            }
        }
        iterator = this.formControls.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nFormControl: ");
            stringBuffer.append(((FormControl)iterator.next()).getDebugInfo());
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getDebugInfo();
    }

    protected void addValues(Collection collection) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addValue((CharSequence)iterator.next());
            }
        }
    }

    protected void addValues(CharSequence[] charSequenceArray) {
        if (charSequenceArray != null) {
            for (int i = 0; i < charSequenceArray.length; ++i) {
                this.addValue(charSequenceArray[i]);
            }
        }
    }

    void addFormControl(FormControl formControl, String string) {
        if (string == null) {
            ++this.userValueCount;
        } else {
            if (this.predefinedValues == null) {
                this.predefinedValues = new LinkedHashSet();
            }
            this.predefinedValues.add(string);
        }
        this.formControls.add(formControl);
        this.allowsMultipleValues = this.calculateAllowsMultipleValues(formControl);
    }

    private boolean calculateAllowsMultipleValues(FormControl formControl) {
        if (this.allowsMultipleValues || this.userValueCount > 1) {
            return true;
        }
        if (this.userValueCount == 1) {
            return this.predefinedValues != null;
        }
        if (this.predefinedValues.size() == 1) {
            return false;
        }
        FormControlType formControlType = formControl.getFormControlType();
        if (this.formControls.size() == 1) {
            return formControlType == FormControlType.SELECT_MULTIPLE;
        }
        FormControlType formControlType2 = this.getFirstFormControl().getFormControlType();
        if (formControlType == FormControlType.RADIO && formControlType2 == FormControlType.RADIO) {
            return false;
        }
        return !formControlType.isSubmit() || !formControlType2.isSubmit();
    }

    protected FormControl getFirstFormControl() {
        if (this.firstFormControl == null) {
            this.firstFormControl = (FormControl)this.formControls.iterator().next();
        }
        return this.firstFormControl;
    }

    protected void merge(FormField formField) {
        Iterator iterator;
        if (formField.userValueCount > this.userValueCount) {
            this.userValueCount = formField.userValueCount;
        }
        boolean bl = this.allowsMultipleValues = this.allowsMultipleValues || formField.allowsMultipleValues;
        if (this.predefinedValues == null) {
            this.predefinedValues = formField.predefinedValues;
        } else if (formField.predefinedValues != null) {
            iterator = formField.predefinedValues.iterator();
            while (iterator.hasNext()) {
                this.predefinedValues.add(iterator.next());
            }
        }
        iterator = formField.getFormControls().iterator();
        while (iterator.hasNext()) {
            this.formControls.add(iterator.next());
        }
    }
}

