/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.mail;

import com.jware.util.mail.BaseMailSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailSenderThread
extends Thread {
    private final Log log = LogFactory.getLog(this.getClass());
    private BaseMailSender mailSender = null;

    public MailSenderThread() {
    }

    public MailSenderThread(BaseMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public MailSenderThread(Runnable target) {
        super(target);
    }

    public MailSenderThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public MailSenderThread(String name) {
        super(name);
    }

    public MailSenderThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public MailSenderThread(Runnable target, String name) {
        super(target, name);
    }

    public MailSenderThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public MailSenderThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    public void run() {
        try {
            if (this.mailSender != null) {
                int result = 0;
                do {
                    if ((result = this.mailSender.execute()) <= 0) continue;
                    Thread.sleep(result);
                } while (result > 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isTheThreadRunning(String name) {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return MailSenderThread.isTheThreadRunning(root, 0, name);
    }

    public static boolean isTheThreadRunning(ThreadGroup group, int level, String name) {
        boolean result = false;
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i2 = 0; i2 < numThreads; ++i2) {
            Thread thread = threads[i2];
            if (!name.equals(thread.getName())) continue;
            result = true;
        }
        if (!result) {
            int numGroups = group.activeGroupCount();
            ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
            numGroups = group.enumerate(groups, false);
            for (int i3 = 0; i3 < numGroups && !(result = MailSenderThread.isTheThreadRunning(groups[i3], level + 1, name)); ++i3) {
            }
        }
        return result;
    }

    public BaseMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(BaseMailSender mailSender) {
        this.mailSender = mailSender;
    }
}

