/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.jobs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.impl.StdSchedulerFactory;

public class InitJobsTest {
    public static void schedTest(SchedulerFactory sf) throws Exception {
        Log lg = LogFactory.getLog(InitJobsTest.class);
        lg.info((Object)"------- Initializing ----------------------");
        Scheduler sched = sf.getScheduler();
        lg.info((Object)"------- Initialization Complete -----------");
        lg.info((Object)"------- (Not Scheduling any Jobs - relying on XML definitions --");
        lg.info((Object)"------- Starting Scheduler ----------------");
        sched.start();
        lg.info((Object)"------- Started Scheduler ----------------");
        lg.info((Object)"------- Waiting... -----------------------");
        try {
            Thread.sleep(300000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lg.info((Object)"------- Shutting Down ---------------------");
        sched.shutdown(true);
        lg.info((Object)"------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        lg.info((Object)("Executed " + metaData.numJobsExecuted() + " jobs."));
    }

    public static void main(String[] args) throws Exception {
        try {
            InitJobsTest.schedTest((SchedulerFactory)new StdSchedulerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

