/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.small;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.HtmlCode;
import org.compiere.util.Language;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class AWebUtil {
    private static CLogger log = CLogger.getCLogger(AWebUtil.class);

    public static void createTimeoutPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, String message) throws ServletException, IOException {
        log.info(message);
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        String windowTitle = "Timeout";
        if (wsc != null) {
            windowTitle = Msg.getMsg((Ctx)wsc.ctx, (String)"Timeout");
        }
        WebDoc doc = WebDoc.create((String)windowTitle);
        body body2 = doc.getBody();
        if (message != null && message.length() > 0) {
            body2.addElement((org.apache.ecs.Element)new p(message, "center"));
        }
        body2.addElement((org.apache.ecs.Element)AWebUtil.getLoginButton(wsc == null ? null : wsc.ctx));
        body2.addElement((org.apache.ecs.Element)new hr());
        body2.addElement((org.apache.ecs.Element)new small(servlet.getClass().getName()));
        AWebUtil.createResponse(request, response, servlet, null, doc, false);
    }

    public static void createErrorPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, String message) throws ServletException, IOException {
        log.info(message);
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        String windowTitle = "Error";
        if (wsc != null) {
            windowTitle = Msg.getMsg((Ctx)wsc.ctx, (String)"Error");
        }
        if (message != null) {
            windowTitle = windowTitle + ": " + message;
        }
        WebDoc doc = WebDoc.create((String)windowTitle);
        body b = doc.getBody();
        b.addElement((org.apache.ecs.Element)new p(servlet.getServletName(), "center"));
        b.addElement((org.apache.ecs.Element)new br());
        AWebUtil.createResponse(request, response, servlet, null, doc, true);
    }

    public static void createLoginPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, Ctx ctx, String AD_Message) throws ServletException, IOException {
        request.getSession().invalidate();
        String url = WebEnv.getBaseDirectory((String)"index.html");
        WebDoc doc = null;
        doc = ctx != null && AD_Message != null && !AD_Message.equals("") ? WebDoc.create((String)Msg.getMsg((Ctx)ctx, (String)AD_Message)) : (AD_Message != null ? WebDoc.create((String)AD_Message) : WebDoc.create((boolean)false));
        script script2 = new script("window.top.location.replace('" + url + "');");
        doc.getBody().addElement((org.apache.ecs.Element)script2);
        AWebUtil.createResponse(request, response, servlet, null, doc, false);
    }

    public static button getLoginButton(Ctx ctx) {
        String text = "Login";
        if (ctx != null) {
            text = Msg.getMsg((Ctx)ctx, (String)"Login");
        }
        button button2 = new button();
        button2.setType("button").setName("Login").addElement(text);
        StringBuffer cmd = new StringBuffer("window.top.location.replace('");
        cmd.append(WebEnv.getBaseDirectory((String)"index.html"));
        cmd.append("');");
        button2.setOnClick(cmd.toString());
        return button2;
    }

    public static Properties getCookieProprties(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("CompiereInfo")) continue;
                return AWebUtil.propertiesDecode(cookies[i].getValue());
            }
        }
        return new Properties();
    }

    public static String getParameter(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return null;
        }
        String enc = request.getCharacterEncoding();
        try {
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
                enc = request.getCharacterEncoding();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", (Throwable)e);
            enc = request.getCharacterEncoding();
        }
        String data = request.getParameter(parameter);
        if (data == null || data.length() == 0) {
            return data;
        }
        if (enc != null && !"UTF-8".equals(enc)) {
            try {
                String dataEnc = new String(data.getBytes(enc), "UTF-8");
                log.log(Level.FINER, "Convert " + data + " (" + enc + ")-> " + dataEnc + " (" + "UTF-8" + ")");
                data = dataEnc;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Convert " + data + " (" + enc + ")->" + "UTF-8");
            }
        }
        String inStr = data;
        StringBuffer outStr = new StringBuffer();
        int i = inStr.indexOf("&#");
        while (i != -1) {
            outStr.append(inStr.substring(0, i));
            inStr = inStr.substring(i + 2, inStr.length());
            int j = inStr.indexOf(";");
            if (j < 0) {
                inStr = "&#" + inStr;
                break;
            }
            String token = inStr.substring(0, j);
            try {
                int intToken = Integer.parseInt(token);
                outStr.append((char)intToken);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Token=" + token, (Throwable)e);
                outStr.append("&#").append(token).append(";");
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf("&#");
        }
        outStr.append(inStr);
        String retValue = outStr.toString();
        log.finest(parameter + "=" + data + " -> " + retValue);
        return retValue;
    }

    public static int getParameterAsInt(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return 0;
        }
        String data = AWebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(data);
        }
        catch (Exception e) {
            log.warning(parameter + "=" + data + " - " + e);
            return 0;
        }
    }

    public static BigDecimal getParameterAsBD(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return Env.ZERO;
        }
        String data = AWebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return Env.ZERO;
        }
        try {
            return new BigDecimal(data);
        }
        catch (Exception e) {
            try {
                DecimalFormat format = DisplayType.getNumberFormat((int)22);
                Object oo = format.parseObject(data);
                if (oo instanceof BigDecimal) {
                    return (BigDecimal)oo;
                }
                if (oo instanceof Number) {
                    return new BigDecimal(((Number)oo).doubleValue());
                }
                return new BigDecimal(oo.toString());
            }
            catch (Exception e2) {
                log.fine(parameter + "=" + data + " - " + e2);
                return Env.ZERO;
            }
        }
    }

    public static Timestamp getParameterAsDate(HttpServletRequest request, String parameter) {
        return AWebUtil.getParameterAsDate(request, parameter, null);
    }

    public static Timestamp getParameterAsDate(HttpServletRequest request, String parameter, Language language) {
        Date date;
        SimpleDateFormat format;
        if (request == null || parameter == null) {
            return null;
        }
        String data = AWebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return null;
        }
        if (language != null) {
            try {
                format = DisplayType.getDateFormat((int)15, (Language)language);
                date = format.parse(data);
                if (date != null) {
                    return new Timestamp(date.getTime());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            format = DisplayType.getDateFormat((int)15);
            date = format.parse(data);
            if (date != null) {
                return new Timestamp(date.getTime());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return Timestamp.valueOf(data);
        }
        catch (Exception e) {
            log.warning(parameter + " - cannot parse: " + data);
            return null;
        }
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String parameter) {
        return AWebUtil.getParameterAsBoolean(request, parameter, null);
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String parameter, String expected) {
        if (request == null || parameter == null) {
            return false;
        }
        String data = AWebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return false;
        }
        if (expected == null) {
            return true;
        }
        return expected.equalsIgnoreCase(data);
    }

    public static void createResponse(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, Properties cookieProperties, WebDoc doc, boolean debug) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        if (cookieProperties != null) {
            Cookie cookie = new Cookie("CompiereInfo", AWebUtil.propertiesEncode(cookieProperties));
            cookie.setComment("(c) ComPiere, Inc - Jorg Janke");
            cookie.setSecure(false);
            cookie.setPath("/");
            if (cookieProperties.size() == 0) {
                cookie.setMaxAge(0);
            } else {
                cookie.setMaxAge(2592000);
            }
            response.addCookie(cookie);
        }
        if (debug && WebEnv.DEBUG) {
            WebEnv.addFooter((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)servlet, (body)doc.getBody());
        }
        PrintWriter out = response.getWriter();
        doc.output(out);
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "error writing");
        }
        out.close();
    }

    public static script getClearFrame(String targetFrame) {
        StringBuffer cmd = new StringBuffer();
        cmd.append("<!-- clear frame\n").append("var d = parent.").append(targetFrame).append(".document;\n").append("d.open();\n").append("d.close();\n").append("// -- clear frame -->");
        return new script(cmd.toString());
    }

    public static HtmlCode getForward(String url, int delaySec) {
        if (delaySec <= 0) {
            delaySec = 3;
        }
        HtmlCode retValue = new HtmlCode();
        a a2 = new a(url);
        a2.addElement(url);
        retValue.addElement((org.apache.ecs.Element)a2);
        script script2 = new script("setTimeout(\"window.top.location.replace('" + url + "')\"," + (delaySec + 1000) + ");");
        retValue.addElement((org.apache.ecs.Element)script2);
        return retValue;
    }

    public static void createForwardPage(HttpServletResponse response, String title, String forwardURL, int delaySec) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        WebDoc doc = WebDoc.create((String)title);
        body b = doc.getBody();
        b.addElement((org.apache.ecs.Element)AWebUtil.getForward(forwardURL, delaySec));
        PrintWriter out = response.getWriter();
        doc.output(out);
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "Error writing");
        }
        out.close();
        log.fine(forwardURL + " - " + title);
    }

    public static boolean exists(String test) {
        if (test == null) {
            return false;
        }
        return test.length() > 0;
    }

    public static boolean exists(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return false;
        }
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", (Throwable)e);
        }
        return AWebUtil.exists(request.getParameter(parameter));
    }

    public static boolean isEmailValid(String email) {
        if (email == null || email.length() == 0) {
            return false;
        }
        try {
            InternetAddress ia = new InternetAddress(email, true);
            ia.getType();
            return true;
        }
        catch (AddressException ex) {
            log.warning(email + " - " + ex.getLocalizedMessage());
            return false;
        }
    }

    public static String propertiesEncode(Properties pp) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            pp.store(bos, "Compiere");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "store", (Throwable)e);
        }
        String result = new String(bos.toByteArray());
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "encodeUTF-8", (Throwable)e);
            String enc = System.getProperty("file.encoding");
            try {
                result = URLEncoder.encode(result, enc);
                log.info("encode: " + enc);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "encode", (Throwable)ex);
            }
        }
        return result;
    }

    public static Properties propertiesDecode(String data) {
        String result = null;
        try {
            result = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "decodeUTF-8", (Throwable)e);
            String enc = System.getProperty("file.encoding");
            try {
                result = URLEncoder.encode(data, enc);
                log.log(Level.SEVERE, "decode: " + enc);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "decode", (Throwable)ex);
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(result.getBytes());
        Properties pp = new Properties();
        try {
            pp.load(bis);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "load", (Throwable)e);
        }
        return pp;
    }

    public static option[] convertToOption(NamePair[] list, String default_ID) {
        int size = list.length;
        option[] retValue = new option[size];
        for (int i = 0; i < size; ++i) {
            boolean selected = false;
            if (i == 0 && (default_ID == null || default_ID.length() == 0)) {
                selected = true;
            }
            String name = Util.maskHTML((String)list[i].getName());
            retValue[i] = new option(list[i].getID()).addElement(name);
            if (default_ID != null && default_ID.equals(list[i].getID())) {
                selected = true;
            }
            retValue[i].setSelected(selected);
        }
        return retValue;
    }

    public static tr createField(tr line, String FORMNAME, String PARAMETER, String labelText, String inputType, Object value, int sizeDisplay, int size, boolean longField, boolean mandatory, String onChange, StringBuffer script2) {
        if (line == null) {
            line = new tr();
        }
        String labelInfo = labelText;
        if (mandatory) {
            labelInfo = labelInfo + "&nbsp;<font color=\"red\">*</font>";
            String fName = "document." + FORMNAME + "." + PARAMETER;
            script2.append(fName).append(".required=true; ");
        }
        label llabel = new label().setFor(PARAMETER).addElement(labelInfo);
        llabel.setID("ID_" + PARAMETER + "_Label");
        line.addElement((org.apache.ecs.Element)new td().addElement((org.apache.ecs.Element)llabel).setAlign("right"));
        input iinput = new input(inputType, PARAMETER, value == null ? "" : value.toString());
        iinput.setSize(sizeDisplay).setMaxlength(size);
        iinput.setID("ID_" + PARAMETER);
        if (onChange != null && onChange.length() > 0) {
            iinput.setOnChange(onChange);
        }
        iinput.setTitle(labelText);
        td field = new td().addElement((org.apache.ecs.Element)iinput).setAlign("left");
        if (longField) {
            field.setColSpan(3);
        }
        line.addElement((org.apache.ecs.Element)field);
        return line;
    }

    public static input createClosePopupButton() {
        input close = new input("button", "closePopup", "Close");
        close.setTitle("Close PopUp");
        close.setOnClick("closePopup();return false;");
        return close;
    }

    public static String streamAttachment(HttpServletResponse response, MAttachment attachment, int attachmentIndex) {
        if (attachment == null) {
            return "No Attachment";
        }
        int realIndex = -1;
        MAttachmentEntry[] entries = attachment.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            MAttachmentEntry entry = entries[i];
            if (entry.getIndex() != attachmentIndex) continue;
            realIndex = i;
            break;
        }
        if (realIndex < 0) {
            log.fine("No Attachment Entry for Index=" + attachmentIndex + " - " + attachment);
            return "Attachment Entry not found";
        }
        MAttachmentEntry entry = entries[realIndex];
        if (entry.getData() == null) {
            log.fine("Empty Attachment Entry for Index=" + attachmentIndex + " - " + attachment);
            return "Attachment Entry empty";
        }
        try {
            int bufferSize = 2048;
            int fileLength = entry.getData().length;
            response.setContentType(entry.getContentType());
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            log.fine(entry.toString());
            long time = System.currentTimeMillis();
            ServletOutputStream out = response.getOutputStream();
            out.write(entry.getData());
            out.flush();
            out.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)(fileLength / 1024) / ((double)time / 1000.0);
            log.info("Length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec - " + entry.getContentType());
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error - " + ex;
        }
        return null;
    }

    public static String streamFile(HttpServletResponse response, File file) {
        if (file == null) {
            return "No File";
        }
        if (!file.exists()) {
            return "File not found: " + file.getAbsolutePath();
        }
        MimeType mimeType = MimeType.get((String)file.getAbsolutePath());
        try {
            int bufferSize = 2048;
            int fileLength = (int)file.length();
            response.setContentType(mimeType.getMimeType());
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            log.fine(file.toString());
            long time = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            int c = 0;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            out.flush();
            out.close();
            in.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)(fileLength / 1024) / ((double)time / 1000.0);
            log.info("Length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec - " + mimeType);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error - " + ex;
        }
        return null;
    }

    public static void createCalloutAjaxResponse(HttpServletResponse response, Document document) throws IOException {
        response.setContentType("text/xml; charset=UTF-8");
        response.addHeader("pragma", "no-store,no-cache");
        response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1");
        response.addHeader("expires", "-1");
        PrintWriter out = null;
        out = response.getWriter();
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(new DOMSource(document), new StreamResult(out));
            File outfile = new File("H:/test.xml");
            transformer.transform(new DOMSource(document), new StreamResult(outfile));
        }
        catch (Exception e) {
            System.out.println("error---- createCalloutAjaxResponse");
        }
    }

    public static String toString(Object obj, WebSessionCtx m_wsc, int displayType, String columnName, GridField field) {
        String ret_str = "";
        if (obj != null) {
            ret_str = 15 == displayType ? m_wsc.dateFormat.format(obj) : (16 == displayType ? m_wsc.dateTimeFormat.format(obj) : (28 == displayType ? AWebUtil.getButtonValue(m_wsc, columnName, (String)obj, field) : obj.toString()));
        }
        return ret_str;
    }

    public static String getButtonValue(WebSessionCtx m_wsc, String columnName, String data, GridField field) {
        String header = "";
        header = columnName.equals("PaymentRule") ? AWebUtil.readReferenceName(m_wsc, 195, data) : (columnName.equals("DocAction") ? AWebUtil.readReferenceName(m_wsc, 135, data) : (columnName.equals("Posted") ? AWebUtil.readReferenceName(m_wsc, 234, data) : field.getHeader()));
        return header;
    }

    public static String readReferenceName(WebSessionCtx m_wsc, int AD_Reference_ID, String value) {
        String name = value;
        String SQL = Env.isBaseLanguage((Ctx)m_wsc.ctx, (String)"AD_Ref_List") ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND VALUE=?" : "SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language((Ctx)m_wsc.ctx) + "'" + " AND l.AD_Reference_ID=?" + " AND l.VALUE=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)SQL, null);
            pstmt.setInt(1, AD_Reference_ID);
            pstmt.setString(2, value);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return name;
    }

    public static void writeDebugLog(String FileName, String source) {
        try {
            FileWriter fw = new FileWriter("H:/compiereWebLog/" + FileName);
            char[] buffer = new char[source.length()];
            source.getChars(0, source.length(), buffer, 0);
            for (int i = 0; i < buffer.length; ++i) {
                fw.write(buffer[i]);
            }
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createDisplayElement(Document document, Element elements, String objId, GridField field, String realOnlyFlag, boolean enabled) {
        Element element = document.createElement("element");
        elements.appendChild(element);
        Element elm_id = document.createElement("id");
        element.appendChild(elm_id);
        elm_id.appendChild(document.createTextNode(objId));
        Element elm_lookup = document.createElement("lookup");
        element.appendChild(elm_lookup);
        elm_lookup.appendChild(document.createTextNode("0"));
        Element elm_visibility = document.createElement("visibility");
        element.appendChild(elm_visibility);
        if (enabled) {
            elm_visibility.appendChild(document.createTextNode("1"));
        } else {
            elm_visibility.appendChild(document.createTextNode("0"));
        }
        Element elm_newValue = document.createElement("newValue");
        element.appendChild(elm_newValue);
        elm_newValue.appendChild(document.createTextNode("1"));
        Element elm_readonly = document.createElement("readonly");
        element.appendChild(elm_readonly);
        elm_readonly.appendChild(document.createTextNode(realOnlyFlag));
        Element elm_type = document.createElement("type");
        element.appendChild(elm_type);
        elm_type.appendChild(document.createTextNode("0"));
    }

    public static void createSaveErrorResponse(HttpServletResponse response, String status) throws IOException {
        response.addHeader("pragma", "no-store,no-cache");
        response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1");
        response.addHeader("expires", "-1");
        response.getOutputStream().print(status);
        System.out.println("-------------createSaveErrorResponse status:" + status);
    }
}

