/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;

    public AttributeValueExp() {
    }

    public String getAttributeName() {
        return this.attr;
    }

    public String toString() {
        return this.attr;
    }

    public AttributeValueExp(String string) {
        this.attr = string;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    protected Object getAttribute(ObjectName objectName) {
        try {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            return mBeanServer.getAttribute(objectName, this.attr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object object = this.getAttribute(objectName);
        if (object instanceof Number) {
            return new NumericValueExp((Number)object);
        }
        if (object instanceof String) {
            return new StringValueExp((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValueExp((Boolean)object);
        }
        throw new BadAttributeValueExpException(object);
    }
}

