/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MTax;
import org.compiere.model.ProductCost;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Invoice
extends Doc {
    private DocTax[] m_taxes = null;
    private int m_precision = -1;
    private boolean m_allLinesService = true;
    private boolean m_allLinesItem = true;

    public Doc_Invoice(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInvoice.class, rs, null, trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MInvoice invoice = (MInvoice)this.getPO();
        this.setDateDoc(invoice.getDateInvoiced());
        this.setIsTaxIncluded(invoice.isTaxIncluded());
        this.setAmount(0, invoice.getGrandTotal());
        this.setAmount(1, invoice.getTotalLines());
        this.setAmount(2, invoice.getChargeAmt());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(invoice);
        this.log.fine("Lines=" + this.p_lines.length + ", Taxes=" + this.m_taxes.length);
        return null;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_InvoiceTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Invoice_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Tax_ID = rs.getInt(1);
                String name = rs.getString(2);
                BigDecimal rate = rs.getBigDecimal(3);
                BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                BigDecimal amount = rs.getBigDecimal(5);
                boolean salesTax = "Y".equals(rs.getString(6));
                DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                this.log.fine(taxLine.toString());
                list.add(taxLine);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return null;
        }
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    private DocLine[] loadLines(MInvoice invoice) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInvoiceLine[] lines = invoice.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MTax tax;
            MInvoiceLine line = lines[i];
            if (line.isDescription()) continue;
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQtyInvoiced();
            boolean cm = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
            docLine.setQty(cm ? Qty.negate() : Qty, invoice.isSOTrx());
            BigDecimal LineNetAmt = line.getLineNetAmt();
            BigDecimal PriceList = line.getPriceList();
            int C_Tax_ID = docLine.getC_Tax_ID();
            if (this.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPercision());
                this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                for (int t = 0; t < this.m_taxes.length; ++t) {
                    if (this.m_taxes[t].getC_Tax_ID() != C_Tax_ID) continue;
                    this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                    break;
                }
                BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPercision());
                PriceList = PriceList.subtract(PriceListTax);
            }
            docLine.setAmount(LineNetAmt, PriceList, Qty);
            if (docLine.isItem()) {
                this.m_allLinesService = false;
            } else {
                this.m_allLinesItem = false;
            }
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        if (this.isTaxIncluded()) {
            block2: for (int i = 0; i < this.m_taxes.length; ++i) {
                if (!this.m_taxes[i].isIncludedTaxDifference()) continue;
                BigDecimal diff = this.m_taxes[i].getIncludedTaxDifference();
                for (int j = 0; j < dls.length; ++j) {
                    if (dls[j].getC_Tax_ID() != this.m_taxes[i].getC_Tax_ID()) continue;
                    dls[j].setLineNetAmtDifference(diff);
                    continue block2;
                }
            }
        }
        return dls;
    }

    private int getStdPercision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    @Override
    public BigDecimal getBalance() {
        int i;
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        for (i = 0; i < this.m_taxes.length; ++i) {
            retValue = retValue.subtract(this.m_taxes[i].getAmount());
            sb.append("-").append(this.m_taxes[i].getAmount());
        }
        for (i = 0; i < this.p_lines.length; ++i) {
            retValue = retValue.subtract(this.p_lines[i].getAmtSource());
            sb.append("-").append(this.p_lines[i].getAmtSource());
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "A");
        if (!as.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("ARI") || this.getDocumentType().equals("ARF")) {
            int i;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            for (i = 0; i < this.m_taxes.length; ++i) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt == null || amt.signum() == 0 || (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            for (i = 0; i < this.p_lines.length; ++i) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), dAmt, amt);
                if (this.p_lines[i].isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i2 = 0; i2 < fLines.length; ++i2) {
                if (fLines[i2] == null) continue;
                fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
            }
            int receivables_ID = this.getValidCombination_ID(1, as);
            int receivablesServices_ID = this.getValidCombination_ID(4, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else if (this.getDocumentType().equals("ARC")) {
            int i;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), amt, null);
            }
            for (i = 0; i < this.m_taxes.length; ++i) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt == null || amt.signum() == 0 || (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt, null)) == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            for (i = 0; i < this.p_lines.length; ++i) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), amt, dAmt);
                if (this.p_lines[i].isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i3 = 0; i3 < fLines.length; ++i3) {
                if (fLines[i3] == null) continue;
                fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), true);
                fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
            }
            int receivables_ID = this.getValidCombination_ID(1, as);
            int receivablesServices_ID = this.getValidCombination_ID(4, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
        } else if (this.getDocumentType().equals("API")) {
            int i;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            for (i = 0; i < this.m_taxes.length; ++i) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                if (tl == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            for (i = 0; i < this.p_lines.length; ++i) {
                BigDecimal discount;
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : desc + " 100%";
                    fl.setDescription(desc);
                }
                if (landedCost) continue;
                MAccount expense = line.getAccount(2, as);
                if (line.isItem()) {
                    expense = line.getAccount(10, as);
                }
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(line, expense, this.getC_Currency_ID(), amt, dAmt);
                if (!line.isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                if (line.getM_Product_ID() == 0 || !line.getProduct().isService()) continue;
                MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource(), line.getQty(), line.getDescription(), this.getTrxName());
            }
            FactLine[] fLines = fact.getLines();
            for (int i4 = 0; i4 < fLines.length; ++i4) {
                if (fLines[i4] == null) continue;
                fLines[i4].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i4].setLocationFromOrg(fLines[i4].getAD_Org_ID(), false);
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            this.updateProductPO(as);
        } else if (this.getDocumentType().equals("APC")) {
            int i;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, this.getAmount(2));
            for (i = 0; i < this.m_taxes.length; ++i) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), null, this.m_taxes[i].getAmount());
                if (tl == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            for (i = 0; i < this.p_lines.length; ++i) {
                BigDecimal discount;
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, false);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : desc + " 100%";
                    fl.setDescription(desc);
                }
                if (landedCost) continue;
                MAccount expense = line.getAccount(2, as);
                if (line.isItem()) {
                    expense = line.getAccount(10, as);
                }
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                }
                fact.createLine(line, expense, this.getC_Currency_ID(), dAmt, amt);
                if (!line.isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                if (line.getM_Product_ID() == 0 || !line.getProduct().isService()) continue;
                MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource().negate(), line.getQty(), line.getDescription(), this.getTrxName());
            }
            FactLine[] fLines = fact.getLines();
            for (int i5 = 0; i5 < fLines.length; ++i5) {
                if (fLines[i5] == null) continue;
                fLines[i5].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i5].setLocationFromOrg(fLines[i5].getAD_Org_ID(), false);
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    public BigDecimal createFactCash(MAcctSchema as, Fact fact, BigDecimal multiplier) {
        int i;
        boolean creditMemo = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
        boolean payables = this.getDocumentType().equals("API") || this.getDocumentType().equals("APC");
        BigDecimal acctAmt = Env.ZERO;
        FactLine fl = null;
        for (i = 0; i < this.p_lines.length; ++i) {
            DocLine line = this.p_lines[i];
            boolean landedCost = false;
            if (payables) {
                landedCost = this.landedCost(as, fact, line, false);
            }
            if (landedCost && as.isExplicitCostAdjustment()) {
                fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                String desc = line.getDescription();
                desc = desc == null ? "100%" : desc + " 100%";
                fl.setDescription(desc);
            }
            if (landedCost) continue;
            MAccount acct = line.getAccount(payables ? 2 : 1, as);
            if (payables && line.isItem()) {
                acct = line.getAccount(10, as);
            }
            BigDecimal amt = line.getAmtSource().multiply(multiplier);
            BigDecimal amt2 = null;
            if (creditMemo) {
                amt2 = amt;
                amt = null;
            }
            if ((fl = payables ? fact.createLine(line, acct, this.getC_Currency_ID(), amt, amt2) : fact.createLine(line, acct, this.getC_Currency_ID(), amt2, amt)) == null) continue;
            acctAmt = acctAmt.add(fl.getAcctBalance());
        }
        for (i = 0; i < this.m_taxes.length; ++i) {
            BigDecimal amt = this.m_taxes[i].getAmount();
            BigDecimal amt2 = null;
            if (creditMemo) {
                amt2 = amt;
                amt = null;
            }
            FactLine tl = null;
            tl = payables ? fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), amt, amt2) : fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt2, amt);
            if (tl == null) continue;
            tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
        }
        FactLine[] fLines = fact.getLines();
        for (int i2 = 0; i2 < fLines.length; ++i2) {
            if (fLines[i2] == null) continue;
            if (payables) {
                fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), false);
                continue;
            }
            fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
            fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
        }
        return acctAmt;
    }

    private boolean landedCost(MAcctSchema as, Fact fact, DocLine line, boolean dr) {
        int C_InvoiceLine_ID = line.get_ID();
        MLandedCostAllocation[] lcas = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        if (lcas.length == 0) {
            return false;
        }
        String sql = "DELETE FROM M_CostDetail WHERE C_InvoiceLine_ID=" + C_InvoiceLine_ID;
        int no = DB.executeUpdate(sql, this.getTrxName());
        if (no != 0) {
            this.log.config("CostDetail Deleted #" + no);
        }
        double totalBase = 0.0;
        for (int i = 0; i < lcas.length; ++i) {
            totalBase += lcas[i].getBase().doubleValue();
        }
        MInvoiceLine il = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        for (int i = 0; i < lcas.length; ++i) {
            MClient client;
            MLandedCostAllocation lca = lcas[i];
            if (lca.getBase().signum() == 0) continue;
            double percent = totalBase / lca.getBase().doubleValue();
            String desc = il.getDescription();
            desc = desc == null ? percent + "%" : desc + " - " + percent + "%";
            if (line.getDescription() != null) {
                desc = desc + " - " + line.getDescription();
            }
            ProductCost pc = new ProductCost(Env.getCtx(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), this.getTrxName());
            BigDecimal drAmt = null;
            BigDecimal crAmt = null;
            if (dr) {
                drAmt = lca.getAmt();
            } else {
                crAmt = lca.getAmt();
            }
            FactLine fl = fact.createLine(line, pc.getAccount(9, as), this.getC_Currency_ID(), drAmt, crAmt);
            fl.setDescription(desc);
            BigDecimal allocationAmt = lca.getAmt();
            if (this.getC_Currency_ID() != as.getC_Currency_ID()) {
                allocationAmt = MConversionRate.convert(this.getCtx(), allocationAmt, this.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            }
            if (allocationAmt.scale() > as.getCostingPrecision()) {
                allocationAmt = allocationAmt.setScale(as.getCostingPrecision(), 4);
            }
            if (!dr) {
                allocationAmt = allocationAmt.negate();
            }
            MCostDetail cd = new MCostDetail(as, lca.getAD_Org_ID(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), lca.getM_CostElement_ID(), allocationAmt, Env.ZERO, desc, this.getTrxName());
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
            boolean ok = cd.save();
            if (!ok || cd.isProcessed() || !(client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) continue;
            cd.process();
        }
        this.log.config("Created #" + lcas.length);
        return true;
    }

    private void updateProductPO(MAcctSchema as) {
        MClientInfo ci = MClientInfo.get(this.getCtx(), as.getAD_Client_ID());
        if (ci.getC_AcctSchema1_ID() != as.getC_AcctSchema_ID()) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_PO po SET PriceLastInv = (SELECT currencyConvert(il.PriceActual,i.C_Currency_ID,po.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) FROM C_Invoice i, C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID");
        if (DB.isOracle()) {
            sql.append(" AND ROWNUM=1) ");
        } else {
            sql.append(" AND i.UPDATED IN (SELECT MAX(i1.UPDATED) FROM C_Invoice i1, C_InvoiceLine il1 WHERE i1.C_Invoice_ID=il1.C_Invoice_ID AND po.M_Product_ID=il1.M_Product_ID AND po.C_BPartner_ID=i1.C_BPartner_ID").append("  AND i1.C_Invoice_ID=").append(this.get_ID()).append(") ");
        }
        sql.append("  AND i.C_Invoice_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM C_Invoice i, C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID AND i.C_Invoice_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("Updated=" + no);
    }
}

