/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jdbc3;

import com.edb.Driver;
import com.edb.core.Field;
import com.edb.jdbc2.AbstractJdbc2Statement;
import com.edb.jdbc3.AbstractJdbc3Connection;
import com.edb.jdbc3.PSQLParameterMetaData;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public abstract class AbstractJdbc3Statement
extends AbstractJdbc2Statement {
    private final int rsHoldability;

    public AbstractJdbc3Statement(AbstractJdbc3Connection c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(c, rsType, rsConcurrency);
        this.rsHoldability = rsHoldability;
    }

    public AbstractJdbc3Statement(AbstractJdbc3Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, isCallable, rsType, rsConcurrency);
        this.rsHoldability = rsHoldability;
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1 && this.result != null && this.result.getResultSet() != null) {
            this.result.getResultSet().close();
        }
        if (this.result != null) {
            this.result = this.result.getNext();
        }
        if (current == 3) {
            while (this.firstUnclosedResult != this.result) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createDriverResultSet(new Field[0], new Vector());
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length == 0) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        int flags = 49;
        AbstractJdbc2Statement.StatementResultHandler handler = new AbstractJdbc2Statement.StatementResultHandler();
        this.connection.getQueryExecutor().execute(this.preparedQuery, this.preparedParameters, handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return new PSQLParameterMetaData(this.connection, oids);
        }
        return null;
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented();
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Driver.notImplemented();
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented();
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setShort(String parameterName, short x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setInt(String parameterName, int x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setLong(String parameterName, long x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setString(String parameterName, String x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented();
    }

    public String getString(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public byte getByte(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public short getShort(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public int getInt(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public long getLong(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public float getFloat(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public double getDouble(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Time getTime(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObject(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObjectImpl(String parameterName, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Blob getBlob(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Clob getClob(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Array getArray(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public URL getURL(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (targetSqlType == 16) {
            targetSqlType = -7;
        }
        super.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 16) {
            sqlType = -7;
        }
        super.setNull(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 16) {
            sqlType = -7;
        }
        super.registerOutParameter(parameterIndex, sqlType);
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }
}

