/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import com.edb.Driver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import oracle.jdbc.OracleDriver;
import org.compiere.install.ProgressPanel;
import org.compiere.swing.PublishInterface;

public class DatabaseCreate
implements Runnable {
    private int m_totalSteps = 1;
    private int m_completedSteps = 0;
    private String m_dbType = null;
    private String m_dbName = null;
    private Connection m_con = null;
    private String m_cUID = null;
    private String m_cPWD = null;
    private PublishInterface m_monitor = null;
    private boolean m_existingDatabase = false;
    private boolean m_success = false;

    public DatabaseCreate(Connection con, String dbtype, String dbname, String compiereUID, String compierePWD, PublishInterface monitor, boolean existingDatabase) throws Exception {
        if (monitor == null) {
            throw new IllegalArgumentException("SetupProgress monitor is NULL.");
        }
        this.m_monitor = monitor;
        if (con == null) {
            throw new IllegalArgumentException("Database connection is NULL");
        }
        this.m_con = con;
        if (dbtype == null) {
            throw new IllegalArgumentException("Database type is NULL");
        }
        this.m_dbType = dbtype;
        if (dbname == null) {
            throw new IllegalArgumentException("Database name is NULL");
        }
        this.m_dbName = dbname;
        if (compiereUID == null) {
            throw new IllegalArgumentException("Database user ID compiereUID is NULL");
        }
        this.m_cUID = compiereUID;
        if (compierePWD == null) {
            throw new IllegalArgumentException("Database user password compierePWD is NULL");
        }
        this.m_cPWD = compierePWD;
        this.m_existingDatabase = existingDatabase;
    }

    public void run() {
        String[] drops = this.getSQLs(false);
        String[] creates = this.getSQLs(true);
        this.m_totalSteps = creates.length + 1;
        this.m_completedSteps = 0;
        if (this.m_existingDatabase) {
            this.m_totalSteps += drops.length;
            this.m_monitor.publish(Level.INFO, "Dropping Database", this.m_completedSteps + 1, this.m_totalSteps);
            this.m_success = this.execute(drops);
            this.m_completedSteps = drops.length;
        } else {
            this.m_success = true;
        }
        if (this.m_success) {
            this.m_monitor.publish(Level.INFO, "Creating Database", this.m_completedSteps + 1, this.m_totalSteps);
            this.m_success = false;
            this.m_success = this.execute(creates);
        }
    }

    private String[] getSQLs(boolean create) {
        if ("oracle".equals(this.m_dbType) || "oracleXE".equals(this.m_dbType)) {
            if (!create) {
                return new String[]{"DROP USER " + this.m_cUID + " CASCADE"};
            }
            return new String[]{"CREATE USER " + this.m_cUID + " IDENTIFIED BY " + this.m_cPWD + " DEFAULT TABLESPACE USERS TEMPORARY TABLESPACE TEMP PROFILE DEFAULT ACCOUNT UNLOCK", "GRANT CONNECT, DBA, RESOURCE TO " + this.m_cUID, "GRANT UNLIMITED TABLESPACE TO " + this.m_cUID, "ALTER USER " + this.m_cUID + " DEFAULT ROLE CONNECT, RESOURCE, DBA"};
        }
        if ("postgreSQL".equals(this.m_dbType)) {
            if (!create) {
                return new String[]{"DROP DATABASE " + this.m_dbName, "DROP ROLE " + this.m_cUID + " CASCADE"};
            }
            return new String[]{"CREATE ROLE " + this.m_cUID + " LOGIN SUPERUSER INHERIT CREATEDB CREATEROLE", "ALTER USER " + this.m_cUID + " IDENTIFIED BY " + this.m_cPWD, "CREATE DATABASE " + this.m_dbName + " ENCODING = 'UNICODE' TABLESPACE = pg_default", "CREATE SCHEMA " + this.m_cUID + " AUTHORIZATION " + this.m_cUID};
        }
        if ("sqlServer".equals(this.m_dbType)) {
            if (!create) {
                return new String[]{"USE MASTER", "DROP DATABASE " + this.m_dbName, "DROP USER " + this.m_cUID, "DROP LOGIN " + this.m_cUID};
            }
            return new String[]{"USE MASTER", "DROP DATABASE " + this.m_dbName, "CREATE DATABASE " + this.m_dbName, "USE " + this.m_dbName, "DROP LOGIN " + this.m_cUID, "CREATE LOGIN " + this.m_cUID + " WITH PASSWORD = '" + this.m_cPWD + "' , DEFAULT_DATABASE = " + this.m_dbName, "CREATE USER " + this.m_cUID + " WITH DEFAULT_SCHEMA = " + this.m_cUID, "CREATE SCHEMA " + this.m_cUID + " AUTHORIZATION " + this.m_cUID, "GRANT TAKE OWNERSHIP, CREATE DEFAULT, CREATE FUNCTION, CREATE PROCEDURE, CREATE RULE, CREATE TABLE, CREATE VIEW, CREATE SYNONYM ON DATABASE::" + this.m_dbName + " TO " + this.m_cUID, "GRANT TAKE OWNERSHIP, ALTER, EXECUTE, INSERT, UPDATE, DELETE, SELECT, REFERENCES, VIEW DEFINITION ON DATABASE::" + this.m_dbName + " TO " + this.m_cUID, "GRANT EXECUTE, INSERT, UPDATE, DELETE, SELECT, REFERENCES, VIEW DEFINITION ON SCHEMA::dbo TO " + this.m_cUID, "CREATE TABLE " + this.m_cUID + ".C_NOTNULL (VIP_COL VARCHAR(28) NOT NULL)", "INSERT INTO " + this.m_cUID + ".C_NOTNULL VALUES ('DO NOT CHANGE ANYTHING HERE!')"};
        }
        throw new IllegalArgumentException("Database Type not supported: " + this.m_dbType);
    }

    private boolean execute(String[] sqls) {
        Statement stmt = null;
        try {
            stmt = this.m_con.createStatement();
        }
        catch (Exception ex) {
            this.m_monitor.publish(Level.SEVERE, "Statement: " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
            return false;
        }
        for (int i = 0; i < sqls.length; ++i) {
            String sql = sqls[i];
            try {
                if ("postgreSQL".equals(this.m_dbType) && sql.startsWith("CREATE SCHEMA")) {
                    String url = this.m_con.getMetaData().getURL();
                    if (url.indexOf("mgmtsvr") > 0) {
                        url = url.replaceAll("mgmtsvr", this.m_dbName);
                    } else if (url.indexOf("edb") > 0) {
                        url = url.replaceAll("edb", this.m_dbName);
                    }
                    Driver s_driver = new Driver();
                    DriverManager.registerDriver((java.sql.Driver)s_driver);
                    try {
                        if (this.m_con != null) {
                            this.m_con.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_con = DriverManager.getConnection(url, this.m_cUID, this.m_cPWD);
                    stmt = this.m_con.createStatement();
                }
                this.m_monitor.publish(Level.FINE, "SQL: " + sql, this.m_completedSteps + i + 1, this.m_totalSteps);
                stmt.executeUpdate(sql);
                if (!"sqlServer".equals(this.m_dbType) || !sql.startsWith("CREATE DATABASE ")) continue;
                String collate = null;
                try {
                    ResultSet rs = stmt.executeQuery("SELECT collation_name FROM master.sys.databases WHERE Name='" + this.m_dbName + "'");
                    if (rs.next()) {
                        collate = rs.getString(1);
                    } else {
                        this.m_monitor.publish(Level.SEVERE, "Could not get COLLATENAME from database" + this.m_dbName, this.m_completedSteps + i + 1, this.m_totalSteps);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.m_monitor.publish(Level.SEVERE, "SELECT collation_name FROM master.sys.databases WHERE Name='" + this.m_dbName + "'  " + e.getMessage(), this.m_completedSteps + i + 1, this.m_totalSteps);
                }
                if (collate != null) {
                    collate = "SQL_Latin1_General_Cp850_BIN2";
                    sql = "ALTER DATABASE " + this.m_dbName + " COLLATE " + collate;
                    this.m_monitor.publish(Level.FINE, "SQL: " + sql, this.m_completedSteps + i + 1, this.m_totalSteps);
                    stmt.executeUpdate(sql);
                    continue;
                }
                this.m_monitor.publish(Level.SEVERE, "COLLATENAME is NULL from database" + this.m_dbName, this.m_completedSteps + i + 1, this.m_totalSteps);
                continue;
            }
            catch (Exception ex) {
                if ("postgreSQL".equals(this.m_dbType)) {
                    if (sql.startsWith("DROP ROLE")) {
                        this.m_monitor.publish(Level.INFO, "Ignore the error from executing SQL: " + sql + "\n " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
                        continue;
                    }
                    if (sql.startsWith("CREATE ROLE")) {
                        this.m_monitor.publish(Level.INFO, "Ignore the error from executing SQL: " + sql + "\n " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
                        continue;
                    }
                    this.m_monitor.publish(Level.SEVERE, sql + "\n " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
                    return false;
                }
                if ("sqlServer".equals(this.m_dbType)) {
                    if (sql.startsWith("DROP DATABASE") || sql.startsWith("DROP USER") || sql.startsWith("DROP LOGIN") || sql.startsWith("DROP SCHEMA")) {
                        this.m_monitor.publish(Level.INFO, "Please check if the Object exists or not. If yes, ignore the error from executing SQL: " + sql + "\n " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
                        continue;
                    }
                    this.m_monitor.publish(Level.SEVERE, sql + "\n " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
                    return false;
                }
                this.m_monitor.publish(Level.SEVERE, sql + "\n " + ex.getMessage(), this.m_totalSteps, this.m_totalSteps);
                return false;
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean isSuccess() {
        return this.m_success;
    }

    public static void main(String[] args) {
        ProgressPanel sp = new ProgressPanel();
        try {
            OracleDriver s_driver;
            Connection con = null;
            if ("oracle".equals(args[1])) {
                s_driver = new OracleDriver();
                DriverManager.registerDriver((java.sql.Driver)s_driver);
                con = DriverManager.getConnection(args[0], "system", "compiere");
            } else {
                s_driver = new Driver();
                DriverManager.registerDriver((java.sql.Driver)s_driver);
                con = DriverManager.getConnection(args[0], "enterprisedb", "compiere");
            }
            DatabaseCreate dbc = new DatabaseCreate(con, args[1], "compiere", "compiere", "compiere", sp, false);
            dbc.run();
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

