/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;

public class ConfigPostgreSQL
extends Config {
    private static com.edb.Driver s_pgDriver = null;
    private Connection m_con = null;

    public ConfigPostgreSQL(ConfigurationData data) {
        super(data);
    }

    public void init() {
        this.p_data.setDatabasePort(String.valueOf(5444));
        this.p_data.setDatabaseSystemPassword(true);
        this.p_data.setDatabaseDiscovered(false);
        this.p_data.setDatabaseName(true);
        this.p_data.setDatabaseUser(true);
    }

    public String[] discoverDatabases(String selected) {
        return new String[]{"compiere"};
    }

    public String test() {
        String server = this.p_data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabaseServer", pass, true, error);
        this.log.info("OK: Database Server = " + databaseServer);
        this.setProperty("COMPIERE_DB_SERVER", databaseServer.getHostName());
        this.setProperty("COMPIERE_DB_TYPE", "postgreSQL");
        this.setProperty("COMPIERE_DB_PATH", "postgreSQL");
        int databasePort = this.p_data.getDatabasePort();
        pass = this.p_data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabasePort", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Database Port = " + databasePort);
        this.setProperty("COMPIERE_DB_PORT", String.valueOf(databasePort));
        String databaseName = this.p_data.getDatabaseName();
        String systemPassword = this.p_data.getDatabaseSystemPassword();
        pass = systemPassword != null && systemPassword.length() > 0;
        error = "No Database System Password entered";
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        String url = "jdbc:edb://" + databaseServer.getHostName() + ":" + databasePort + "/";
        String url1 = url + "edb";
        pass = this.testJDBC(url1, "enterprisedb", systemPassword);
        error = "Error connecting: " + url1 + " - as enterprisedb/" + systemPassword;
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Connection = " + url1);
        this.log.info("OK: Database System User " + databaseName);
        this.setProperty("COMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = this.p_data.getDatabaseUser();
        String databasePassword = this.p_data.getDatabasePassword();
        pass = databasePassword != null && databasePassword.length() > 0;
        error = "Invalid Database User Password";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        String url2 = url + databaseName;
        pass = this.testJDBC(url2, databaseUser, databasePassword);
        error = "Cannot connect to " + databaseName + " User: " + databaseUser + "/" + databasePassword + " - Database may not be imported yet (OK on initial run).";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, false, error);
        if (pass) {
            this.log.info("OK: Connection = " + url2);
            this.log.info("OK: Database User = " + databaseUser);
            if (this.m_con != null) {
                this.setProperty("COMPIERE_WEBSTORES", this.getWebStores(this.m_con));
            }
            this.setProperty("COMPIERE_DB_USER_EXISTS", "Y");
        } else {
            this.setProperty("COMPIERE_DB_USER_EXISTS", "N");
            this.log.warning(error);
        }
        this.setProperty("COMPIERE_DB_URL", url2);
        this.setProperty("COMPIERE_DB_NAME", databaseName);
        this.setProperty("COMPIERE_DB_USER", databaseUser);
        this.setProperty("COMPIERE_DB_PASSWORD", databasePassword);
        this.m_con = null;
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        this.log.fine("Url=" + url + ", UID=" + uid);
        try {
            if (s_pgDriver == null) {
                s_pgDriver = new com.edb.Driver();
                DriverManager.registerDriver((Driver)s_pgDriver);
            }
            this.m_con = DriverManager.getConnection(url, uid, pwd);
        }
        catch (Exception e) {
            this.log.warning(e.toString());
            return false;
        }
        return true;
    }
}

