/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.MBeanMBean;
import org.jboss.management.j2ee.StateManagement;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.system.ServiceMBean;

public class MBean
extends J2EEManagedObject
implements MBeanMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$MBean == null ? (class$org$jboss$management$j2ee$MBean = MBean.class$("org.jboss.management.j2ee.MBean")) : class$org$jboss$management$j2ee$MBean));
    private ObjectName jbossServiceName;
    private StateManagement mState = new StateManagement(this);
    private boolean monitorsStateChanges = false;
    static /* synthetic */ Class class$org$jboss$management$j2ee$MBean;
    static /* synthetic */ Class class$org$jboss$system$ServiceMBean;

    public static ObjectName create(MBeanServer pServer, String pServiceModule, ObjectName pTarget) {
        String pName = pTarget.toString();
        ObjectName mbeanName = null;
        try {
            if (pServiceModule == null) {
                log.debug((Object)"Parent SAR Module not defined");
                return null;
            }
            MBean mbean = new MBean(pName, new ObjectName(pServiceModule), pTarget);
            mbeanName = mbean.getObjectName();
            pServer.registerMBean(mbean, mbeanName);
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 MBean: " + pName), (Throwable)e);
        }
        return mbeanName;
    }

    public static void destroy(MBeanServer pServer, String pName) {
        try {
            if (pName.indexOf("j2eeType=MBean") >= 0) {
                J2EEManagedObject.removeObject(pServer, pName);
            } else {
                J2EEManagedObject.removeObject(pServer, pName, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "MBean" + "," + "*");
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not destroy JSR-77 MBean: " + pName), (Throwable)e);
        }
    }

    public MBean(String pName, ObjectName pServiceModule, ObjectName pTarget) throws MalformedObjectNameException, InvalidParentException {
        super("MBean", pName, pServiceModule);
        this.jbossServiceName = pTarget;
    }

    public boolean isstateMonitored() {
        return this.monitorsStateChanges;
    }

    public void postCreation() {
        try {
            this.monitorsStateChanges = this.getServer().isInstanceOf(this.jbossServiceName, "javax.management.NotificationBroadcaster");
            if (this.monitorsStateChanges) {
                this.getServer().addNotificationListener(this.jbossServiceName, this.mState, null, null);
            }
        }
        catch (Exception jme) {
            log.debug((Object)("Failed to register as listener of: " + this.jbossServiceName), (Throwable)jme);
        }
        this.sendNotification("j2ee.object.created", "MBean created");
        try {
            ServiceMBean mbean = (ServiceMBean)MBeanProxy.get((Class)(class$org$jboss$system$ServiceMBean == null ? (class$org$jboss$system$ServiceMBean = MBean.class$("org.jboss.system.ServiceMBean")) : class$org$jboss$system$ServiceMBean), (ObjectName)this.jbossServiceName, (MBeanServer)this.getServer());
            int jbossState = mbean.getState();
            int jsr77State = StateManagement.convertJBossState(jbossState);
            this.mState.setState(jsr77State);
        }
        catch (Exception e) {
            log.trace((Object)("Failed to initialze state from: " + this.jbossServiceName), (Throwable)e);
        }
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "MBean destroyed");
        try {
            if (this.monitorsStateChanges) {
                this.getServer().removeNotificationListener(this.jbossServiceName, this.mState);
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public String getStateString() {
        return this.mState.getStateString();
    }

    public void mejbStart() {
        try {
            this.getServer().invoke(this.jbossServiceName, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Start of MBean failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        this.mejbStart();
    }

    public void mejbStop() {
        try {
            this.getServer().invoke(this.jbossServiceName, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of MBean failed", (Throwable)e);
        }
    }

    public String toString() {
        return "MBean { " + super.toString() + " } []";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("ServiceModule", lProperties.get("name"));
        lReturn.put("J2EEApplication", "null");
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

