/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import javax.management.Notification;
import org.jboss.monitor.alarm.Alarm;

public class AlarmNotification
extends Notification {
    private int alarmState;
    private int severity;
    static /* synthetic */ Class class$org$jboss$monitor$alarm$AlarmNotification;

    public AlarmNotification(String type, Object source, long sequenceNumber, long timeStamp, String message, int alarmState, int severity) {
        super(type, source, sequenceNumber, timeStamp, message);
        switch (alarmState) {
            case 0: {
                this.alarmState = 0;
                this.severity = 0;
                break;
            }
            case 1: 
            case 2: {
                this.alarmState = alarmState;
                if (severity > 0 && severity <= 5) {
                    this.severity = severity;
                    break;
                }
                this.severity = 5;
                break;
            }
            default: {
                this.alarmState = 3;
                this.severity = severity >= 0 && severity <= 5 ? severity : 5;
            }
        }
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getAlarmState() {
        return this.alarmState;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append((class$org$jboss$monitor$alarm$AlarmNotification == null ? (class$org$jboss$monitor$alarm$AlarmNotification = AlarmNotification.class$("org.jboss.monitor.alarm.AlarmNotification")) : class$org$jboss$monitor$alarm$AlarmNotification).getName());
        sbuf.append(" [ source=").append(this.getSource());
        sbuf.append(", type=").append(this.getType());
        sbuf.append(", sequenceNumber=").append(this.getSequenceNumber());
        sbuf.append(", timeStamp=").append(this.getTimeStamp());
        sbuf.append(", message=").append(this.getMessage());
        sbuf.append(", userData=").append(this.getUserData());
        sbuf.append(", alarmState=").append(Alarm.STATE_STRINGS[this.alarmState]);
        sbuf.append(", severity=").append(Alarm.SEVERITY_STRINGS[this.severity]);
        sbuf.append(" ]");
        return sbuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

