/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ArrayDataResultSet
extends BaseResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    PhysicalConnection connection;
    private Boolean wasNull;
    private static Boolean BOOLEAN_TRUE = new Boolean(true);
    private static Boolean BOOLEAN_FALSE = new Boolean(false);
    private int fetchSize;
    ARRAY array;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:08_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(n3 - this.currentIndex, n2);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.array = aRRAY;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.array == null ? 0 : aRRAY.length();
        this.lastIndex = this.currentIndex + (n2 == -1 ? n3 - this.currentIndex : Math.min(n3 - this.currentIndex, n2));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public boolean next() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
        }
        ++this.currentIndex;
        return this.currentIndex <= this.lastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.wasNull == null) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24, null);
            }
            return this.wasNull;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.stringValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
            return null;
        }
    }

    public Datum getOracleObject(int n2) throws SQLException {
        if (this.currentIndex <= 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14, null);
        }
        if (n2 == 1) {
            this.wasNull = BOOLEAN_FALSE;
            return new NUMBER(this.currentIndex);
        }
        if (n2 == 2) {
            Datum[] datumArray;
            if (this.data != null) {
                this.wasNull = this.data[this.currentIndex - 1] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return this.data[this.currentIndex - 1];
            }
            if (this.array != null && (datumArray = this.array.getOracleArray(this.currentIndex, 1)) != null && datumArray.length >= 1) {
                this.wasNull = datumArray[0] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return datumArray[0];
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync");
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    return (ROWID)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    return (NUMBER)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof DATE) {
                    return (DATE)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    return (ARRAY)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return (STRUCT)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    return (OPAQUE)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof REF) {
                    return (REF)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    return (CHAR)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return (RAW)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    return (BLOB)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    return (CLOB)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    return (BFILE)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    return (INTERVALDS)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    return (INTERVALYM)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    return (TIMESTAMP)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    return (TIMESTAMPTZ)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    return (TIMESTAMPLTZ)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.booleanValue();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.byteValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2 = this.getLong(n2);
            if (l2 > 65537L || l2 < -65538L) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
            }
            return (short)l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.intValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.longValue();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.floatValue();
            }
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.doubleValue();
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.bigDecimalValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return ((RAW)datum).shareBytes();
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.dateValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.timeValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.timestampValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                datum.asciiStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.binaryStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getObject(n2, this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return customDatumFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return oRADataFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string.equalsIgnoreCase("index")) {
                return 1;
            }
            if (string.equalsIgnoreCase("value")) {
                return 2;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                return datum.toJdbc();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.characterStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.bigDecimalValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                if (dATE != null) {
                    return dATE.dateValue(calendar);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                if (dATE != null) {
                    return dATE.timeValue(calendar);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                if (dATE != null) {
                    return dATE.timestampValue(calendar);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwUnsupportedFeatureSqlException();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            return null;
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentIndex < 1;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentIndex > this.lastIndex;
    }

    public boolean isFirst() throws SQLException {
        return this.currentIndex == 1;
    }

    public boolean isLast() throws SQLException {
        return this.currentIndex == this.lastIndex;
    }

    public int getRow() throws SQLException {
        return this.currentIndex;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        } else {
            this.fetchSize = n2 == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n2;
        }
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

