/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;

public class RemoteHostFilter
implements Filter {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$filters$RemoteHostFilter == null ? (class$org$jboss$web$tomcat$filters$RemoteHostFilter = RemoteHostFilter.class$("org.jboss.web.tomcat.filters.RemoteHostFilter")) : class$org$jboss$web$tomcat$filters$RemoteHostFilter));
    private String[] allow;
    private String[] deny;
    private boolean trace = log.isTraceEnabled();
    private FilterConfig filterConfig = null;
    static /* synthetic */ Class class$org$jboss$web$tomcat$filters$RemoteHostFilter;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String clientAddr = request.getRemoteAddr();
        if (this.trace) {
            log.trace((Object)("Client addres is: " + clientAddr));
        }
        if (this.hasMatch(clientAddr, this.deny)) {
            this.handleInvalidAccess(request, response, clientAddr);
            return;
        }
        if (this.allow.length > 0 && !this.hasMatch(clientAddr, this.allow)) {
            this.handleInvalidAccess(request, response, clientAddr);
            return;
        }
        chain.doFilter(request, response);
    }

    private void handleInvalidAccess(ServletRequest request, ServletResponse response, String clientAddr) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = httpRequest.getRequestURL().toString();
        if (this.trace) {
            log.trace((Object)("Invalid access attempt to " + url + " from " + clientAddr));
        }
        httpResponse.sendError(403);
    }

    private boolean hasMatch(String clientAddr, String[] regExps) {
        for (int i = 0; i < regExps.length; ++i) {
            if (!clientAddr.matches(regExps[i])) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        this.filterConfig = null;
        this.allow = null;
        this.deny = null;
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.allow = this.extractRegExps(filterConfig.getInitParameter("allow"));
        this.deny = this.extractRegExps(filterConfig.getInitParameter("deny"));
    }

    private String[] extractRegExps(String initParam) {
        if (initParam == null) {
            return new String[0];
        }
        return initParam.split(",");
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "ClientAddrFilter()";
        }
        StringBuffer sb = new StringBuffer("ClientAddrFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

