/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.StringUtil;

public abstract class POILogger {
    public static final int DEBUG = 1;
    public static final int INFO = 3;
    public static final int WARN = 5;
    public static final int ERROR = 7;
    public static final int FATAL = 9;

    POILogger() {
    }

    public abstract void initialize(String var1);

    public abstract void log(int var1, Object var2);

    public abstract boolean check(int var1);

    public void log(int level, Object obj1, Object obj2) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(32).append(obj1).append(obj2));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(48).append(obj1).append(obj2).append(obj3));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(64).append(obj1).append(obj2).append(obj3).append(obj4));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(80).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(96).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(112).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(128).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7).append(obj8));
        }
    }

    public void log(int level, Object obj1, Throwable exception) {
        this.log(level, obj1, exception);
    }

    public void log(int level, Object obj1, Object obj2, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(32).append(obj1).append(obj2), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(48).append(obj1).append(obj2).append(obj3), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(64).append(obj1).append(obj2).append(obj3).append(obj4), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(80).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(96).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(112).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(128).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7).append(obj8), exception);
        }
    }

    public void logFormatted(int level, String message, Object obj1) {
        this.commonLogFormatted(level, message, new Object[]{obj1});
    }

    public void logFormatted(int level, String message, Object obj1, Object obj2) {
        this.commonLogFormatted(level, message, new Object[]{obj1, obj2});
    }

    public void logFormatted(int level, String message, Object obj1, Object obj2, Object obj3) {
        this.commonLogFormatted(level, message, new Object[]{obj1, obj2, obj3});
    }

    public void logFormatted(int level, String message, Object obj1, Object obj2, Object obj3, Object obj4) {
        this.commonLogFormatted(level, message, new Object[]{obj1, obj2, obj3, obj4});
    }

    private void commonLogFormatted(int level, String message, Object[] unflatParams) {
        if (this.check(level)) {
            Object[] params = this.flattenArrays(unflatParams);
            if (params[params.length - 1] instanceof Throwable) {
                this.log(level, (Object)StringUtil.format(message, params), (Throwable)params[params.length - 1]);
            } else {
                this.log(level, StringUtil.format(message, params));
            }
        }
    }

    private Object[] flattenArrays(Object[] objects) {
        ArrayList results = new ArrayList();
        for (int i2 = 0; i2 < objects.length; ++i2) {
            results.addAll(this.objectToObjectArray(objects[i2]));
        }
        return results.toArray(new Object[results.size()]);
    }

    private List objectToObjectArray(Object object2) {
        int j;
        Object[] array;
        ArrayList<Object> results = new ArrayList<Object>();
        if (object2 instanceof byte[]) {
            array = (byte[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Byte(array[j]));
            }
        }
        if (object2 instanceof char[]) {
            array = (char[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Character((char)array[j]));
            }
        } else if (object2 instanceof short[]) {
            array = (short[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Short(array[j]));
            }
        } else if (object2 instanceof int[]) {
            array = (int[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Integer(array[j]));
            }
        } else if (object2 instanceof long[]) {
            array = (long[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Long(array[j]));
            }
        } else if (object2 instanceof float[]) {
            array = (float[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Float(array[j]));
            }
        } else if (object2 instanceof double[]) {
            array = (double[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(new Double(array[j]));
            }
        } else if (object2 instanceof Object[]) {
            array = (Object[])object2;
            for (j = 0; j < array.length; ++j) {
                results.add(array[j]);
            }
        } else {
            results.add(object2);
        }
        return results;
    }
}

