/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FontRecord
extends Record {
    public static final short sid = 49;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private short field_1_font_height;
    private short field_2_attributes;
    private static final BitField italic = new BitField(2);
    private static final BitField strikeout = new BitField(8);
    private static final BitField macoutline = new BitField(16);
    private static final BitField macshadow = new BitField(32);
    private short field_3_color_palette_index;
    private short field_4_bold_weight;
    private short field_5_super_sub_script;
    private byte field_6_underline;
    private byte field_7_family;
    private byte field_8_charset;
    private byte field_9_zero = 0;
    private byte field_10_font_name_len;
    private String field_11_font_name;

    public FontRecord() {
    }

    public FontRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FontRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 49) {
            throw new RecordFormatException("NOT A FONT RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_font_height = LittleEndian.getShort(data, 0 + offset);
        this.field_2_attributes = LittleEndian.getShort(data, 2 + offset);
        this.field_3_color_palette_index = LittleEndian.getShort(data, 4 + offset);
        this.field_4_bold_weight = LittleEndian.getShort(data, 6 + offset);
        this.field_5_super_sub_script = LittleEndian.getShort(data, 8 + offset);
        this.field_6_underline = data[10 + offset];
        this.field_7_family = data[11 + offset];
        this.field_8_charset = data[12 + offset];
        this.field_9_zero = data[13 + offset];
        this.field_10_font_name_len = data[14 + offset];
        if (this.field_10_font_name_len > 0) {
            this.field_11_font_name = data[15] == 0 ? StringUtil.getFromCompressedUnicode(data, 16, LittleEndian.ubyteToInt(this.field_10_font_name_len)) : StringUtil.getFromUnicodeHigh(data, 16, this.field_10_font_name_len);
        }
    }

    public void setFontHeight(short height) {
        this.field_1_font_height = height;
    }

    public void setAttributes(short attributes) {
        this.field_2_attributes = attributes;
    }

    public void setItalic(boolean italics) {
        this.field_2_attributes = italic.setShortBoolean(this.field_2_attributes, italics);
    }

    public void setStrikeout(boolean strike2) {
        this.field_2_attributes = strikeout.setShortBoolean(this.field_2_attributes, strike2);
    }

    public void setMacoutline(boolean mac) {
        this.field_2_attributes = macoutline.setShortBoolean(this.field_2_attributes, mac);
    }

    public void setMacshadow(boolean mac) {
        this.field_2_attributes = macshadow.setShortBoolean(this.field_2_attributes, mac);
    }

    public void setColorPaletteIndex(short cpi) {
        this.field_3_color_palette_index = cpi;
    }

    public void setBoldWeight(short bw) {
        this.field_4_bold_weight = bw;
    }

    public void setSuperSubScript(short sss) {
        this.field_5_super_sub_script = sss;
    }

    public void setUnderline(byte u2) {
        this.field_6_underline = u2;
    }

    public void setFamily(byte f2) {
        this.field_7_family = f2;
    }

    public void setCharset(byte charset) {
        this.field_8_charset = charset;
    }

    public void setFontNameLength(byte len) {
        this.field_10_font_name_len = len;
    }

    public void setFontName(String fn) {
        this.field_11_font_name = fn;
    }

    public short getFontHeight() {
        return this.field_1_font_height;
    }

    public short getAttributes() {
        return this.field_2_attributes;
    }

    public boolean isItalic() {
        return italic.isSet(this.field_2_attributes);
    }

    public boolean isStruckout() {
        return strikeout.isSet(this.field_2_attributes);
    }

    public boolean isMacoutlined() {
        return macoutline.isSet(this.field_2_attributes);
    }

    public boolean isMacshadowed() {
        return macshadow.isSet(this.field_2_attributes);
    }

    public short getColorPaletteIndex() {
        return this.field_3_color_palette_index;
    }

    public short getBoldWeight() {
        return this.field_4_bold_weight;
    }

    public short getSuperSubScript() {
        return this.field_5_super_sub_script;
    }

    public byte getUnderline() {
        return this.field_6_underline;
    }

    public byte getFamily() {
        return this.field_7_family;
    }

    public byte getCharset() {
        return this.field_8_charset;
    }

    public byte getFontNameLength() {
        return this.field_10_font_name_len;
    }

    public String getFontName() {
        return this.field_11_font_name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FONT]\n");
        buffer.append("    .fontheight      = ").append(Integer.toHexString(this.getFontHeight())).append("\n");
        buffer.append("    .attributes      = ").append(Integer.toHexString(this.getAttributes())).append("\n");
        buffer.append("         .italic     = ").append(this.isItalic()).append("\n");
        buffer.append("         .strikout   = ").append(this.isStruckout()).append("\n");
        buffer.append("         .macoutlined= ").append(this.isMacoutlined()).append("\n");
        buffer.append("         .macshadowed= ").append(this.isMacshadowed()).append("\n");
        buffer.append("    .colorpalette    = ").append(Integer.toHexString(this.getColorPaletteIndex())).append("\n");
        buffer.append("    .boldweight      = ").append(Integer.toHexString(this.getBoldWeight())).append("\n");
        buffer.append("    .supersubscript  = ").append(Integer.toHexString(this.getSuperSubScript())).append("\n");
        buffer.append("    .underline       = ").append(Integer.toHexString(this.getUnderline())).append("\n");
        buffer.append("    .family          = ").append(Integer.toHexString(this.getFamily())).append("\n");
        buffer.append("    .charset         = ").append(Integer.toHexString(this.getCharset())).append("\n");
        buffer.append("    .namelength      = ").append(Integer.toHexString(this.getFontNameLength())).append("\n");
        buffer.append("    .fontname        = ").append(this.getFontName()).append("\n");
        buffer.append("[/FONT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int realflen = this.getFontNameLength() * 2;
        LittleEndian.putShort(data, 0 + offset, (short)49);
        LittleEndian.putShort(data, 2 + offset, (short)(15 + realflen + 1));
        LittleEndian.putShort(data, 4 + offset, this.getFontHeight());
        LittleEndian.putShort(data, 6 + offset, this.getAttributes());
        LittleEndian.putShort(data, 8 + offset, this.getColorPaletteIndex());
        LittleEndian.putShort(data, 10 + offset, this.getBoldWeight());
        LittleEndian.putShort(data, 12 + offset, this.getSuperSubScript());
        data[14 + offset] = this.getUnderline();
        data[15 + offset] = this.getFamily();
        data[16 + offset] = this.getCharset();
        data[17 + offset] = 0;
        data[18 + offset] = this.getFontNameLength();
        data[19 + offset] = 1;
        if (this.getFontName() != null) {
            StringUtil.putUncompressedUnicode(this.getFontName(), data, 20 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return this.getFontNameLength() * 2 + 20;
    }

    public short getSid() {
        return 49;
    }
}

