/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.poi.ddf.EscherProperties;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherComplexProperty
extends EscherProperty {
    byte[] complexData = new byte[0];

    public EscherComplexProperty(short id, byte[] complexData) {
        super(id);
        this.complexData = complexData;
    }

    public EscherComplexProperty(short propertyNumber, boolean isBlipId, byte[] complexData) {
        super(propertyNumber, true, isBlipId);
        this.complexData = complexData;
    }

    public int serializeSimplePart(byte[] data, int pos) {
        LittleEndian.putShort(data, pos, this.getId());
        LittleEndian.putInt(data, pos + 2, this.complexData.length);
        return 6;
    }

    public int serializeComplexPart(byte[] data, int pos) {
        System.arraycopy(this.complexData, 0, data, pos, this.complexData.length);
        return this.complexData.length;
    }

    public byte[] getComplexData() {
        return this.complexData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EscherComplexProperty)) {
            return false;
        }
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)o;
        return Arrays.equals(this.complexData, escherComplexProperty.complexData);
    }

    public int getPropertySize() {
        return 6 + this.complexData.length;
    }

    public int hashCode() {
        return this.getId() * 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String toString() {
        void var1_2;
        String dataStr;
        ByteArrayOutputStream b2 = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.complexData, 0L, b2, 0);
            dataStr = b2.toString();
        }
        catch (Exception e2) {
            dataStr = e2.toString();
        }
        finally {
            try {
                b2.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + System.getProperty("line.separator") + (String)var1_2;
    }
}

