/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;

public class NDC {
    static Hashtable ht = new Hashtable();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    private NDC() {
    }

    public static void clear() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null) {
            stack.setSize(0);
        }
    }

    public static Stack cloneStack() {
        Object o = ht.get(Thread.currentThread());
        if (o == null) {
            return null;
        }
        Stack stack = (Stack)o;
        return (Stack)stack.clone();
    }

    public static void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    public static String get() {
        Stack s2 = (Stack)ht.get(Thread.currentThread());
        if (s2 != null && !s2.isEmpty()) {
            return ((DiagnosticContext)s2.peek()).fullMessage;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    private static void lazyRemove() {
        Thread t;
        Vector<Thread> v;
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            if (++pushCounter <= 5) {
                return;
            }
            pushCounter = 0;
            int misses = 0;
            v = new Vector<Thread>();
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements() && misses <= 4) {
                t = (Thread)enumeration.nextElement();
                if (t.isAlive()) {
                    ++misses;
                    continue;
                }
                misses = 0;
                v.addElement(t);
            }
        }
        int size = v.size();
        int i2 = 0;
        while (i2 < size) {
            t = (Thread)v.elementAt(i2);
            LogLog.debug("Lazy NDC removal for thread [" + t.getName() + "] (" + ht.size() + ").");
            ht.remove(t);
            ++i2;
        }
    }

    public static String pop() {
        Thread key = Thread.currentThread();
        Stack stack = (Stack)ht.get(key);
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static String peek() {
        Thread key = Thread.currentThread();
        Stack stack = (Stack)ht.get(key);
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.peek()).message;
        }
        return "";
    }

    public static void push(String message) {
        Thread key = Thread.currentThread();
        Stack<DiagnosticContext> stack = (Stack<DiagnosticContext>)ht.get(key);
        if (stack == null) {
            DiagnosticContext dc = new DiagnosticContext(message, null);
            stack = new Stack<DiagnosticContext>();
            ht.put(key, stack);
            stack.push(dc);
        } else if (stack.isEmpty()) {
            DiagnosticContext dc = new DiagnosticContext(message, null);
            stack.push(dc);
        } else {
            DiagnosticContext parent = (DiagnosticContext)stack.peek();
            stack.push(new DiagnosticContext(message, parent));
        }
    }

    public static void remove() {
        ht.remove(Thread.currentThread());
        NDC.lazyRemove();
    }

    public static void setMaxDepth(int maxDepth) {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && maxDepth < stack.size()) {
            stack.setSize(maxDepth);
        }
    }

    private static class DiagnosticContext {
        String fullMessage;
        String message;

        DiagnosticContext(String message, DiagnosticContext parent) {
            this.message = message;
            this.fullMessage = parent != null ? parent.fullMessage + ' ' + message : message;
        }
    }
}

