/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.ClassNameSpace;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class Name
implements Serializable {
    public NameSpace namespace;
    String value = null;
    private String evalName;
    private String lastEvalName;
    private static String FINISHED = null;
    private Object evalBaseObject;
    private int callstackDepth;
    Class asClass;
    Class classOfStaticMethod;

    private void reset() {
        this.evalName = this.value;
        this.evalBaseObject = null;
        this.callstackDepth = 0;
    }

    Name(NameSpace nameSpace, String string) {
        this.namespace = nameSpace;
        this.value = string;
    }

    public Object toObject(CallStack callStack, Interpreter interpreter) throws UtilEvalError {
        return this.toObject(callStack, interpreter, false);
    }

    public synchronized Object toObject(CallStack callStack, Interpreter interpreter, boolean bl) throws UtilEvalError {
        this.reset();
        Object object2 = null;
        while (this.evalName != null) {
            object2 = this.consumeNextObjectField(callStack, interpreter, bl, false);
        }
        if (object2 == null) {
            throw new InterpreterError("null value in toObject()");
        }
        return object2;
    }

    private Object completeRound(String string, String string2, Object object2) {
        this.lastEvalName = string;
        this.evalName = string2;
        this.evalBaseObject = object2;
        return object2;
    }

    private Object consumeNextObjectField(CallStack callStack, Interpreter interpreter, boolean bl, boolean bl2) throws UtilEvalError {
        Object object2;
        Object object3;
        Object object4;
        if (this.evalBaseObject == null && !Name.isCompound(this.evalName) && !bl && (object4 = this.resolveThisFieldReference(callStack, this.namespace, interpreter, this.evalName, false)) != Primitive.VOID) {
            return this.completeRound(this.evalName, FINISHED, object4);
        }
        object4 = Name.prefix(this.evalName, 1);
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !bl) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying to resolve variable: " + (String)object4);
            }
            if ((object3 = this.evalBaseObject == null ? this.resolveThisFieldReference(callStack, this.namespace, interpreter, (String)object4, false) : this.resolveThisFieldReference(callStack, ((This)this.evalBaseObject).namespace, interpreter, (String)object4, true)) != Primitive.VOID) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("resolved variable: " + (String)object4 + " in namespace: " + this.namespace);
                }
                return this.completeRound((String)object4, Name.suffix(this.evalName), object3);
            }
        }
        if (this.evalBaseObject == null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying class: " + this.evalName);
            }
            object3 = null;
            int n = 1;
            object2 = null;
            while (n <= Name.countParts(this.evalName)) {
                object2 = Name.prefix(this.evalName, n);
                object3 = this.namespace.getClass((String)object2);
                if (object3 != null) break;
                ++n;
            }
            if (object3 != null) {
                return this.completeRound((String)object2, Name.suffix(this.evalName, Name.countParts(this.evalName) - n), new ClassIdentifier((Class)object3));
            }
            if (Interpreter.DEBUG) {
                Interpreter.debug("not a class, trying var prefix " + this.evalName);
            }
        }
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !bl && bl2) {
            object3 = this.evalBaseObject == null ? this.namespace : ((This)this.evalBaseObject).namespace;
            This this_ = new NameSpace((NameSpace)object3, "auto: " + (String)object4).getThis(interpreter);
            ((NameSpace)object3).setVariable((String)object4, this_, false);
            return this.completeRound((String)object4, Name.suffix(this.evalName), this_);
        }
        if (this.evalBaseObject == null) {
            if (!Name.isCompound(this.evalName)) {
                return this.completeRound(this.evalName, FINISHED, Primitive.VOID);
            }
            throw new UtilEvalError("Class or variable not found: " + this.evalName);
        }
        if (this.evalBaseObject == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Null Pointer while evaluating: " + this.value));
        }
        if (this.evalBaseObject == Primitive.VOID) {
            throw new UtilEvalError("Undefined variable or class name while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof Primitive) {
            throw new UtilEvalError("Can't treat primitive like an object. Error while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof ClassIdentifier) {
            String string;
            Class clazz;
            String string2;
            block26: {
                object3 = ((ClassIdentifier)this.evalBaseObject).getTargetClass();
                string2 = Name.prefix(this.evalName, 1);
                object2 = null;
                try {
                    if (Interpreter.DEBUG) {
                        Interpreter.debug("Name call to getStaticField, class: " + object3 + ", field:" + string2);
                    }
                    object2 = Reflect.getStaticField((Class)object3, string2);
                }
                catch (ReflectError reflectError) {
                    if (!Interpreter.DEBUG) break block26;
                    Interpreter.debug("field reflect error: " + reflectError);
                }
            }
            if (object2 == null && (clazz = this.namespace.getClass(string = ((Class)object3).getName() + "$" + string2)) != null) {
                object2 = new ClassIdentifier(clazz);
            }
            if (object2 == null) {
                throw new UtilEvalError("No static field or inner class: " + string2 + " of " + object3);
            }
            return this.completeRound(string2, Name.suffix(this.evalName), object2);
        }
        if (bl) {
            throw new UtilEvalError(this.value + " does not resolve to a class name.");
        }
        object3 = Name.prefix(this.evalName, 1);
        if (((String)object3).equals("length") && this.evalBaseObject.getClass().isArray()) {
            Primitive primitive = new Primitive(Array.getLength(this.evalBaseObject));
            return this.completeRound((String)object3, Name.suffix(this.evalName), primitive);
        }
        try {
            Object object5 = Reflect.getObjectField(this.evalBaseObject, (String)object3);
            return this.completeRound((String)object3, Name.suffix(this.evalName), object5);
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Cannot access field: " + (String)object3 + ", on object: " + this.evalBaseObject);
        }
    }

    Object resolveThisFieldReference(CallStack callStack, NameSpace nameSpace, Interpreter interpreter, String string, boolean bl) throws UtilEvalError {
        Object object2 = null;
        if (string.equals("this")) {
            if (bl) {
                throw new UtilEvalError("Redundant to call .this on This type");
            }
            This this_ = nameSpace.getThis(interpreter);
            nameSpace = this_.getNameSpace();
            if (nameSpace.isMethod && nameSpace.getParent() != null && nameSpace.getParent() instanceof ClassNameSpace && ((ClassNameSpace)nameSpace.getParent()).isClassInstance()) {
                this_ = nameSpace.getParent().getThis(interpreter);
            }
            return this_;
        }
        if (string.equals("super")) {
            This this_ = nameSpace.getSuper().getThis(interpreter);
            if ((nameSpace = this_.getNameSpace()) instanceof ClassNameSpace && ((ClassNameSpace)nameSpace).isClassInstance() && nameSpace.getParent() != null && nameSpace.getParent() instanceof ClassNameSpace && ((ClassNameSpace)nameSpace.getParent()).isClassInstance()) {
                this_ = nameSpace.getParent().getThis(interpreter);
            }
            return this_;
        }
        if (string.equals("global")) {
            object2 = nameSpace.getGlobal().getThis(interpreter);
        }
        if (object2 == null && bl) {
            if (string.equals("namespace")) {
                object2 = nameSpace;
            } else if (string.equals("variables")) {
                object2 = nameSpace.getVariableNames();
            } else if (string.equals("methods")) {
                object2 = nameSpace.getMethodNames();
            } else if (string.equals("interpreter")) {
                if (this.lastEvalName.equals("this")) {
                    object2 = interpreter;
                } else {
                    throw new UtilEvalError("Can only call .interpreter on literal 'this'");
                }
            }
        }
        if (object2 == null && bl && string.equals("caller")) {
            if (this.lastEvalName.equals("this") || this.lastEvalName.equals("caller")) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
            } else {
                throw new UtilEvalError("Can only call .caller on literal 'this' or literal '.caller'");
            }
            object2 = callStack.get(++this.callstackDepth).getThis(interpreter);
            return object2;
        }
        if (object2 == null && bl && string.equals("callstack")) {
            if (this.lastEvalName.equals("this")) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
                object2 = callStack;
            } else {
                throw new UtilEvalError("Can only call .callstack on literal 'this'");
            }
        }
        if (object2 == null) {
            object2 = nameSpace.getVariable(string);
        }
        return object2;
    }

    public synchronized Class toClass() throws ClassNotFoundException, UtilEvalError {
        if (this.asClass != null) {
            return this.asClass;
        }
        this.reset();
        if (this.evalName.equals("var")) {
            this.asClass = null;
            return null;
        }
        Class clazz = this.namespace.getClass(this.evalName);
        if (clazz == null) {
            Object object2 = null;
            try {
                object2 = this.toObject(null, null, true);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
            if (object2 instanceof ClassIdentifier) {
                clazz = ((ClassIdentifier)object2).getTargetClass();
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class: " + this.value + " not found in namespace");
        }
        this.asClass = clazz;
        return this.asClass;
    }

    public synchronized LHS toLHS(CallStack callStack, Interpreter interpreter) throws UtilEvalError {
        this.reset();
        if (!Name.isCompound(this.evalName)) {
            LHS lHS = new LHS(this.namespace, this.evalName, false);
            return lHS;
        }
        Object object2 = null;
        try {
            while (this.evalName != null && Name.isCompound(this.evalName)) {
                object2 = this.consumeNextObjectField(callStack, interpreter, false, true);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new UtilEvalError("LHS evaluation: " + utilEvalError);
        }
        if (this.evalName == null && object2 instanceof ClassIdentifier) {
            throw new UtilEvalError("Can't assign to class: " + this.value);
        }
        if (object2 == null) {
            throw new UtilEvalError("Error in LHS: " + this.value);
        }
        if (object2 instanceof This) {
            if (this.evalName.equals("namespace") || this.evalName.equals("variables") || this.evalName.equals("methods") || this.evalName.equals("caller")) {
                throw new UtilEvalError("Can't assign to special variable: " + this.evalName);
            }
            Interpreter.debug("found This reference evaluating LHS");
            boolean bl = !this.lastEvalName.equals("super");
            return new LHS(((This)object2).namespace, this.evalName, bl);
        }
        if (this.evalName != null) {
            try {
                if (object2 instanceof ClassIdentifier) {
                    Class clazz = ((ClassIdentifier)object2).getTargetClass();
                    LHS lHS = Reflect.getLHSStaticField(clazz, this.evalName);
                    return lHS;
                }
                LHS lHS = Reflect.getLHSObjectField(object2, this.evalName);
                return lHS;
            }
            catch (ReflectError reflectError) {
                throw new UtilEvalError("Field access: " + reflectError);
            }
        }
        throw new InterpreterError("Internal error in lhs...");
    }

    public Object invokeMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws UtilEvalError, EvalError, ReflectError, InvocationTargetException {
        Class clazz;
        String string = Name.suffix(this.value, 1);
        BshClassManager bshClassManager = callStack.top().getClassManager();
        if (this.classOfStaticMethod != null) {
            return Reflect.invokeStaticMethod(bshClassManager, this.classOfStaticMethod, string, objectArray);
        }
        if (!Name.isCompound(this.value)) {
            return this.invokeLocalMethod(interpreter, objectArray, callStack, simpleNode);
        }
        Name name = this.namespace.getNameResolver(Name.prefix(this.value));
        Object object2 = name.toObject(callStack, interpreter);
        if (object2 == Primitive.VOID) {
            throw new UtilEvalError("Attempt to resolve method: " + string + "() on undefined variable or class name: " + name);
        }
        if (!(object2 instanceof ClassIdentifier)) {
            if (object2 instanceof Primitive) {
                if (object2 == Primitive.NULL) {
                    throw new UtilTargetError(new NullPointerException("Null Pointer in Method Invocation"));
                }
                if (Interpreter.DEBUG) {
                    Interpreter.debug("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
                }
            }
            return Reflect.invokeObjectMethod(object2, string, objectArray, interpreter, callStack, simpleNode);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeMethod: trying static - " + name);
        }
        this.classOfStaticMethod = clazz = ((ClassIdentifier)object2).getTargetClass();
        if (clazz != null) {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, string, objectArray);
        }
        throw new UtilEvalError("invokeMethod: unknown target: " + name);
    }

    private Object invokeLocalMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        Object object2;
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeLocalMethod: " + this.value);
        }
        if (interpreter == null) {
            throw new InterpreterError("invokeLocalMethod: interpreter = null");
        }
        String string = this.value;
        Class[] classArray = Reflect.getTypes(objectArray);
        BshMethod bshMethod = null;
        try {
            bshMethod = this.namespace.getMethod(string, classArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Local method invocation", simpleNode, callStack);
        }
        if (bshMethod != null) {
            return bshMethod.invoke(objectArray, interpreter, callStack, simpleNode);
        }
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            object2 = this.namespace.getCommand(string, classArray, interpreter);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error loading command: ", simpleNode, callStack);
        }
        if (object2 == null) {
            BshMethod bshMethod2 = null;
            try {
                bshMethod2 = this.namespace.getMethod("invoke", new Class[]{null, null});
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError("Local method invocation", simpleNode, callStack);
            }
            if (bshMethod2 != null) {
                return bshMethod2.invoke(new Object[]{string, objectArray}, interpreter, callStack, simpleNode);
            }
            throw new EvalError("Command not found: " + StringUtil.methodString(string, classArray), simpleNode, callStack);
        }
        if (object2 instanceof BshMethod) {
            return ((BshMethod)object2).invoke(objectArray, interpreter, callStack, simpleNode);
        }
        if (object2 instanceof Class) {
            try {
                return Reflect.invokeCompiledCommand((Class)object2, objectArray, interpreter, callStack);
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError("Error invoking compiled command: ", simpleNode, callStack);
            }
        }
        throw new InterpreterError("invalid command type");
    }

    public static boolean isCompound(String string) {
        return string.indexOf(46) != -1;
    }

    static int countParts(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n2 + 1)) != -1) {
            ++n;
        }
        return n + 1;
    }

    static String prefix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.prefix(string, Name.countParts(string) - 1);
    }

    static String prefix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string.indexOf(46, n3 + 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(0, n3);
    }

    static String suffix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.suffix(string, Name.countParts(string) - 1);
    }

    public static String suffix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length() + 1;
        while ((n3 = string.lastIndexOf(46, n3 - 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(n3 + 1);
    }

    public String toString() {
        return this.value;
    }
}

