/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHType;
import bsh.CallStack;
import bsh.CollectionManager;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.UtilEvalError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class BSHPrimarySuffix
extends SimpleNode {
    public static final int CLASS = 0;
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public int operation;
    Object index;
    public String field;

    BSHPrimarySuffix(int n) {
        super(n);
    }

    public Object doSuffix(Object object2, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.operation == 0) {
            if (object2 instanceof BSHType) {
                if (bl) {
                    throw new EvalError("Can't assign .class", this, callStack);
                }
                NameSpace nameSpace = callStack.top();
                return ((BSHType)object2).getType(callStack, interpreter);
            }
            throw new EvalError("Attempt to use .class suffix on non class.", this, callStack);
        }
        if (object2 instanceof SimpleNode) {
            object2 = object2 instanceof BSHAmbiguousName ? ((BSHAmbiguousName)object2).toObject(callStack, interpreter) : ((SimpleNode)object2).eval(callStack, interpreter);
        } else if (object2 instanceof LHS) {
            try {
                object2 = ((LHS)object2).getValue();
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError(this, callStack);
            }
        }
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(object2, bl, callStack, interpreter);
                }
                case 2: {
                    return this.doName(object2, bl, callStack, interpreter);
                }
                case 3: {
                    return this.doProperty(bl, object2, callStack, interpreter);
                }
            }
            throw new InterpreterError("Unknown suffix type");
        }
        catch (ReflectError reflectError) {
            throw new EvalError("reflection error: " + reflectError, this, callStack);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TargetError("target exception", invocationTargetException.getTargetException(), this, callStack, true);
        }
    }

    private Object doName(Object object2, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        try {
            if (this.field.equals("length") && object2.getClass().isArray()) {
                if (bl) {
                    throw new EvalError("Can't assign array length", this, callStack);
                }
                return new Primitive(Array.getLength(object2));
            }
            if (this.jjtGetNumChildren() == 0) {
                if (bl) {
                    return Reflect.getLHSObjectField(object2, this.field);
                }
                return Reflect.getObjectField(object2, this.field);
            }
            Object[] objectArray = ((BSHArguments)this.jjtGetChild(0)).getArguments(callStack, interpreter);
            return Reflect.invokeObjectMethod(object2, this.field, objectArray, interpreter, callStack, this);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    static int getIndexAux(Object object2, CallStack callStack, Interpreter interpreter, SimpleNode simpleNode) throws EvalError {
        int n;
        if (!object2.getClass().isArray()) {
            throw new EvalError("Not an array", simpleNode, callStack);
        }
        try {
            Object object3 = ((SimpleNode)simpleNode.jjtGetChild(0)).eval(callStack, interpreter);
            if (!(object3 instanceof Primitive)) {
                object3 = NameSpace.getAssignableForm(object3, Integer.TYPE);
            }
            n = ((Primitive)object3).intValue();
        }
        catch (UtilEvalError utilEvalError) {
            Interpreter.debug("doIndex: " + utilEvalError);
            throw utilEvalError.toEvalError("Arrays may only be indexed by integer types.", simpleNode, callStack);
        }
        return n;
    }

    private Object doIndex(Object object2, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError {
        int n = BSHPrimarySuffix.getIndexAux(object2, callStack, interpreter, this);
        if (bl) {
            return new LHS(object2, n);
        }
        try {
            return Reflect.getIndex(object2, n);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    private Object doProperty(boolean bl, Object object2, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (object2 == Primitive.VOID) {
            throw new EvalError("Attempt to access property on undefined variable or class name", this, callStack);
        }
        if (object2 instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this, callStack);
        }
        Object object3 = ((SimpleNode)this.jjtGetChild(0)).eval(callStack, interpreter);
        if (!(object3 instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this, callStack);
        }
        if (bl) {
            return new LHS(object2, (String)object3);
        }
        CollectionManager collectionManager = CollectionManager.getCollectionManager();
        if (collectionManager.isMap(object2)) {
            Object object4 = collectionManager.getFromMap(object2, object3);
            return object4 == null ? (object4 = Primitive.NULL) : object4;
        }
        try {
            return Reflect.getObjectProperty(object2, (String)object3);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Property: " + object3, this, callStack);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("No such property: " + object3, this, callStack);
        }
    }
}

