/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Wire {
    private static final Log WIRE_LOG = LogFactory.getLog((String)"httpclient.wire");

    Wire() {
    }

    public static final boolean enabled() {
        return WIRE_LOG.isDebugEnabled();
    }

    public static final void input(int b) throws IOException {
        Wire.input(new byte[]{(byte)b});
    }

    public static final void input(InputStream instream) throws IOException {
        if (instream == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.wire("<< ", instream);
    }

    public static final void input(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.input(s.getBytes());
    }

    public static final void input(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.wire("<< ", new ByteArrayInputStream(b));
    }

    public static final void input(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.wire("<< ", new ByteArrayInputStream(b, off, len));
    }

    public static final void output(int b) throws IOException {
        Wire.output(new byte[]{(byte)b});
    }

    public static final void output(InputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.wire(">> ", outstream);
    }

    public static final void output(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.output(s.getBytes());
    }

    public static final void output(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.wire(">> ", new ByteArrayInputStream(b));
    }

    public static final void output(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.wire(">> ", new ByteArrayInputStream(b, off, len));
    }

    private static void wire(String header, InputStream instream) throws IOException {
        int ch;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(instream, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            reader = new InputStreamReader(instream);
        }
        StringBuffer buffer = new StringBuffer();
        while ((ch = ((Reader)reader).read()) != -1) {
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                WIRE_LOG.debug((Object)buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append("\"");
            buffer.insert(0, "\"");
            buffer.insert(0, header);
            WIRE_LOG.debug((Object)buffer.toString());
        }
    }
}

