#!/bin/sh

INSTALL_DIR=/usr/local
PACKAGE_NAME=cmx
RELEASE_NAME=dppatheditor-0.10
SYMLINK_NAME=dppatheditor
BIN_DIR=bin
BIN_NAME=dppatheditor

srcdir=$(cd $(dirname $0) && pwd)

mkdir -p $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME
cp -r $srcdir/* $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME/

cat <<EOF > $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME/$BIN_NAME
#!/bin/sh

DPPathEditor_HOME=$INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME

myclasspath=\$DPPathEditor_HOME/dppatheditor.jar
for jarfile in \$DpPathEditor/lib/*.jar
do 
  myclasspath=\$myclasspath:\$jarfile
done
CLASSPATH=\$myclasspath:\$CLASSPATH
export CLASSPATH

java jp.crestmuse.cmx.gui.dppatheditor.DpPathEditor \$*
EOF

chmod +x $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME/$BIN_NAME
(cd $INSTALL_DIR/$PACKAGE_NAME ; ln -sf $RELEASE_NAME $SYMLINK_NAME)
mkdir -p $INSTALL_DIR/$BIN_DIR
ln -sf $INSTALL_DIR/$PACKAGE_NAME/$SYMLINK_NAME/$BIN_NAME \
  $INSTALL_DIR/$BIN_DIR/$BIN_NAME
