#!/bin/zsh

setopt null_glob

release=`basename $PWD`
JAR_FILE=dppatheditor.jar

mkdir classes
javac -d classes -target 1.5 -sourcepath src src/**/*.java
( cd classes ; jar cvfm ../${JAR_FILE} ../MANIFEST.MF * )
rm -r classes

if [ -e doc ] ; then
  rm -r doc/*
else
  mkdir doc
fi
javadoc -d doc -protected -version -author -quiet src/**/*.java

( cd ../ ; [ -e ${release}.zip ] && rm ${release}.zip ; zip -r ${release}.zip $release -x ${release}/**/.svn/**/{*,.*} ${release}**/*~ )

