/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.HashMap;

public final class MIDIConst {
    public static final short NOTE_OFF = 128;
    public static final short NOTE_ON = 144;
    public static final short POLY_KEY_PRESSURE = 160;
    public static final short CONTROL_CHANGE = 176;
    public static final short PROGRAM_CHANGE = 192;
    public static final short CHANNEL_KEY_PRESSURE = 208;
    public static final short PITCH_BEND_CHANGE = 224;
    public static final short ALL_SOUND_OFF = 120;
    public static final short RESET_ALL_CONTROLLERS = 121;
    public static final short LOCAL_CONTROL = 122;
    public static final short ALL_NOTES_OFF = 123;
    public static final short OMNI_OFF = 124;
    public static final short OMNI_ON = 125;
    public static final short MONO_MODE = 126;
    public static final short POLY_MODE = 125;
    public static final short META_EVENT = 127;
    public static final short END_OF_TRACK = 47;
    public static final short SET_TEMPO = 81;
    public static final short SMPTE_OFFSET = 84;
    public static final short TIME_SIGNATURE = 88;
    public static final short KEY_SIGNATURE = 89;
    public static final byte OFF = 0;
    public static final byte ON = 127;
    public static final byte DUMMY_VALUE = 0;
    private static final HashMap<String, Short> CHNL_MSG = new HashMap();
    private static final HashMap<Short, String> CHNL_MSG2 = new HashMap();
    private static final HashMap<String, Short> META_EVENTS = new HashMap();
    private static final HashMap<Short, String> META_EVENTS2 = new HashMap();
    private static final HashMap<String, String[]> ATTLIST = new HashMap();

    private static void addChannelMessage(String string, short s, String ... stringArray) {
        CHNL_MSG.put(string, s);
        CHNL_MSG2.put(s, string);
        ATTLIST.put(string, stringArray);
    }

    private static void addMetaEvent(String string, short s, String ... stringArray) {
        META_EVENTS.put(string, s);
        META_EVENTS2.put(s, string);
        ATTLIST.put(string, stringArray);
    }

    public static boolean isSupportedMessage(String string) {
        return CHNL_MSG.containsKey(string);
    }

    public static boolean isSupportedMessage(short s) {
        return CHNL_MSG2.containsKey(s);
    }

    public static short msgNameToStatusNo(String string) {
        return CHNL_MSG.get(string);
    }

    public static String statusNoToMsgName(short s) {
        return CHNL_MSG2.get(s);
    }

    public static boolean isSupportedMetaEvent(String string) {
        return META_EVENTS.containsKey(string);
    }

    public static boolean isSupportedMetaEvent(short s) {
        return META_EVENTS2.containsKey(s);
    }

    public static short metaEventNameToType(String string) {
        return META_EVENTS.get(string);
    }

    public static String metaEventTypeToName(short s) {
        return META_EVENTS2.get(s);
    }

    public static String[] getAttributeList(String string) {
        return ATTLIST.get(string);
    }

    public static boolean msbFirst(String string) {
        return !string.equals("PitchBendChange");
    }

    public static boolean msgFirst(short s) {
        return s != 224;
    }

    public static byte getByteLength(String string) {
        if (string.equals("PitchBendChange")) {
            return 2;
        }
        if (string.equals("SetTempo")) {
            return 3;
        }
        return 1;
    }

    public static byte getByteLength(short s) {
        if (s == 224) {
            return 2;
        }
        if (s == 81) {
            return 3;
        }
        return 1;
    }

    public static boolean isOnOffMessage(String string) {
        return string.equals("LocalControl");
    }

    public static byte onOffMsgStringToByte(String string) {
        if (string.equalsIgnoreCase("on")) {
            return 127;
        }
        if (string.equalsIgnoreCase("off")) {
            return 0;
        }
        throw new IllegalArgumentException("Not on or off: " + string);
    }

    public static String onOffMsgByteToString(byte by) {
        if (by == 127) {
            return "on";
        }
        if (by == 0) {
            return "off";
        }
        throw new IllegalArgumentException("Illegal value: " + by);
    }

    static {
        MIDIConst.addChannelMessage("NoteOn", (short)144, "Note", "Velocity");
        MIDIConst.addChannelMessage("NoteOff", (short)128, "Note", "Velocity");
        MIDIConst.addChannelMessage("PolyKeyPressure", (short)160, "Note", "Pressure");
        MIDIConst.addChannelMessage("ControlChange", (short)176, "Control", "Value");
        MIDIConst.addChannelMessage("ProgramChange", (short)192, "Number");
        MIDIConst.addChannelMessage("ChannelKeyPresure", (short)208, "Pressure");
        MIDIConst.addChannelMessage("PitchBendChange", (short)224, "Value");
        MIDIConst.addChannelMessage("AllSoundOff", (short)120, new String[0]);
        MIDIConst.addChannelMessage("ResetAllControllers", (short)121, new String[0]);
        MIDIConst.addChannelMessage("LocalControl", (short)122, "Value");
        MIDIConst.addChannelMessage("AllNotesOff", (short)123, new String[0]);
        MIDIConst.addChannelMessage("OmniOff", (short)124, new String[0]);
        MIDIConst.addChannelMessage("OmniOn", (short)125, new String[0]);
        MIDIConst.addChannelMessage("MonoMode", (short)126, "Value");
        MIDIConst.addChannelMessage("PolyMode", (short)125, new String[0]);
        MIDIConst.addMetaEvent("EndOfTrack", (short)47, new String[0]);
        MIDIConst.addMetaEvent("SetTempo", (short)81, "Value");
        MIDIConst.addMetaEvent("TimeSignature", (short)88, "Numerator", "LogDenominator", "MIDIClocksPerMetronomeClick", "ThirtySecondsPer24Clocks");
        MIDIConst.addMetaEvent("KeySignature", (short)89, "Fifths", "Mode");
    }
}

