/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.ComplexNumber;
import jp.crestmuse.cmx.math.MathException;

class DefaultComplexArray
implements ComplexArray {
    private double[] re;
    private double[] im;
    private int from;
    private int thru;

    DefaultComplexArray(int n) {
        this.re = new double[n];
        this.im = new double[n];
        this.from = 0;
        this.thru = n;
    }

    DefaultComplexArray(double[] dArray, double[] dArray2) {
        this.re = dArray;
        this.im = dArray2;
        this.from = 0;
        this.thru = dArray.length;
        if (this.thru != dArray2.length) {
            throw new MathException("inconsistent data size");
        }
    }

    public int length() {
        return this.thru - this.from;
    }

    public double getReal(int n) {
        return this.re[this.from + n];
    }

    public double getImag(int n) {
        if (this.im == null) {
            return 0.0;
        }
        return this.im[this.from + n];
    }

    public ComplexNumber get(int n) {
        return new ComplexNumber(this.getReal(n), this.getImag(n));
    }

    public void setReal(int n, double d) {
        this.re[this.from + n] = d;
    }

    public void setImag(int n, double d) {
        if (this.im == null) {
            this.im = new double[this.thru - this.from];
        }
        this.im[this.from + n] = d;
    }

    public void set(int n, double d, double d2) {
        this.setReal(n, d);
        this.setImag(n, d2);
    }

    public void set(int n, ComplexNumber complexNumber) {
        this.set(n, complexNumber.real, complexNumber.imag);
    }

    public ComplexArray subarrayX(int n, int n2) {
        DefaultComplexArray defaultComplexArray = new DefaultComplexArray(this.re, this.im);
        defaultComplexArray.from = this.from + n;
        defaultComplexArray.thru = this.from + n2;
        return defaultComplexArray;
    }
}

