/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.inference.LtoRHMMChain;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LtoRHMMChainCalcModule
extends SPModule {
    private LtoRHMMChain<ObservationVector> hmmchain;
    private int nHMMs;
    private double[][] prevLogLik = null;

    public LtoRHMMChainCalcModule(LtoRHMMChain<ObservationVector> ltoRHMMChain) {
        this.hmmchain = ltoRHMMChain;
        this.nHMMs = ltoRHMMChain.nHMMs();
    }

    @Override
    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        DoubleArray doubleArray = (DoubleArray)objectArray[0];
        ObservationVector observationVector = new ObservationVector(doubleArray.toArray());
        this.prevLogLik = this.prevLogLik == null ? this.hmmchain.calcLogLikelihood1st(observationVector) : this.hmmchain.calcLogLikelihood(observationVector, this.prevLogLik);
        for (int i = 0; i < this.nHMMs; ++i) {
            timeSeriesCompatibleArray[i].add(Utils.createDoubleArray(this.prevLogLik[i]));
        }
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{DoubleArray.class};
    }

    @Override
    public Class[] getOutputClasses() {
        Class[] classArray = new Class[this.nHMMs];
        for (int i = 0; i < this.nHMMs; ++i) {
            classArray[i] = DoubleArray.class;
        }
        return classArray;
    }
}

