/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.LinkedList;
import jp.crestmuse.cmx.inference.BayesNetCompatible;
import jp.crestmuse.cmx.inference.BayesianMapping;
import jp.crestmuse.cmx.inference.MusicLayerListener;
import jp.crestmuse.cmx.inference.MusicRepresentation2;

public class BayesianDPSearcher
implements MusicLayerListener {
    private BayesNetCompatible bayesNet;
    private LinkedList<BayesianMapping> readMappings;
    private LinkedList<BayesianMapping> writeMappings;
    private String prevnode;
    private String currnode;
    private BayesianMapping bmPrevNode;
    private BayesianMapping bmCurrNode;
    private double penalty = 0.0;

    public BayesianDPSearcher(BayesNetCompatible bayesNetCompatible, String string, String string2) {
        this.bayesNet = bayesNetCompatible;
        this.readMappings = new LinkedList();
        this.writeMappings = new LinkedList();
        this.prevnode = string;
        this.currnode = string2;
    }

    public void update(MusicRepresentation2 musicRepresentation2, MusicRepresentation2.MusicElement musicElement, int n, int n2) {
        if (n == musicRepresentation2.getMeasureNum()) {
            return;
        }
        try {
            Object object;
            Object i;
            Object object2;
            for (BayesianMapping object42 : this.readMappings) {
                object2 = object42.mappedElement(musicRepresentation2, n, n2);
                if (object2 == null) continue;
                if (object42.evidenceOnly || ((MusicRepresentation2.MusicElement)object2).hasEvidence()) {
                    this.bayesNet.setEvidence(object42.bayesnetIndex, ((MusicRepresentation2.MusicElement)object2).getHighestProbIndex());
                    continue;
                }
                i = new double[][]{((MusicRepresentation2.MusicElement)object2).getAllProbs()};
                this.bayesNet.setDistribution(object42.bayesnetIndex, (double[][])i);
            }
            MusicRepresentation2.MusicElement musicElement2 = this.bmPrevNode.mappedElement(musicRepresentation2, n, n2);
            MusicRepresentation2.MusicElement musicElement3 = this.bmCurrNode.mappedElement(musicRepresentation2, n, n2);
            if (musicElement2 == null) {
                this.bayesNet.update();
                object2 = this.bayesNet.getMargin(this.bmCurrNode.bayesnetIndex);
                for (int bayesianMapping = 0; bayesianMapping < ((String[])object2).length; ++bayesianMapping) {
                    musicElement3.setProb(bayesianMapping, (double)object2[bayesianMapping]);
                }
            } else {
                int dArray;
                object2 = this.bayesNet.getValues(this.bmPrevNode.bayesnetIndex);
                i = this.bayesNet.getValues(this.bmCurrNode.bayesnetIndex);
                object = new double[((String[])object2).length][];
                for (dArray = 0; dArray < ((Object)object2).length; ++dArray) {
                    this.bayesNet.setEvidence(this.bmPrevNode.bayesnetIndex, dArray);
                    this.bayesNet.update();
                    object[dArray] = this.bayesNet.getMargin(this.bmCurrNode.bayesnetIndex);
                }
                for (dArray = 0; dArray < ((double[][])i).length; ++dArray) {
                    double d = Double.NEGATIVE_INFINITY;
                    int n3 = -1;
                    for (int j = 0; j < ((Object)object2).length; ++j) {
                        double d2 = Math.log(object[j][dArray]) + musicElement2.getLogLikelihood(j) + (j == dArray ? -this.penalty : 0.0);
                        if (!(d2 > d)) continue;
                        d = d2;
                        n3 = j;
                    }
                    System.err.print(d + " ");
                    musicElement3.setLogLikelihood(dArray, d);
                    musicElement3.setBackPointer(dArray, n3);
                }
                System.err.println();
                musicElement3.setBackPointerTo(musicElement2);
            }
            for (BayesianMapping bayesianMapping : this.writeMappings) {
                if (bayesianMapping == this.bmCurrNode || (object = (Object)bayesianMapping.mappedElement(musicRepresentation2, n, n2)) == null) continue;
                double[] dArray = this.bayesNet.getMargin(bayesianMapping.bayesnetIndex);
                for (int j = 0; j < dArray.length; ++j) {
                    ((MusicRepresentation2.MusicElement)object).removeEvidence(j);
                    ((MusicRepresentation2.MusicElement)object).setProb(j, dArray[j]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException(exception.toString());
        }
    }

    public void setContinuationPenalty(double d) {
        this.penalty = d;
    }

    public void addReadMapping(BayesianMapping bayesianMapping) {
        this.readMappings.add(bayesianMapping);
        if (bayesianMapping.bayesnetIndex == this.bayesNet.getNode(this.prevnode)) {
            this.bmPrevNode = bayesianMapping;
        }
    }

    public void addWriteMapping(BayesianMapping bayesianMapping) {
        this.writeMappings.add(bayesianMapping);
        if (bayesianMapping.bayesnetIndex == this.bayesNet.getNode(this.currnode)) {
            this.bmCurrNode = bayesianMapping;
        }
    }
}

