/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jp.crestmuse.cmx.filewrappers.MusicApexWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.NoteGroup;
import jp.crestmuse.cmx.handlers.CommonNoteHandler;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.PianoRollCompatible;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicApexDataSet {
    private final MusicXMLWrapper musicxml;
    private boolean inherited = false;
    private String aspect = null;
    private AbstractGroup topGroup = null;
    private HashMap<Node, MusicXMLWrapper.Note> noteMap = new HashMap();
    private final int type;

    public MusicApexDataSet(MusicXMLWrapper musicXMLWrapper, int n, boolean bl) {
        this.musicxml = musicXMLWrapper;
        this.type = n;
        this.inherited = bl;
    }

    public NoteGroup createTopLevelGroup() {
        this.topGroup = (AbstractGroup)this.createGroup();
        this.topGroup.depth = 1;
        this.musicxml.processNotes(new CommonNoteHandler(){

            public void processNote(NoteCompatible noteCompatible, PianoRollCompatible pianoRollCompatible) {
                MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)noteCompatible;
                MusicApexDataSet.this.topGroup.addNote(note);
                MusicApexDataSet.this.noteMap.put(note.node(), note);
            }

            public void endPart(String string, PianoRollCompatible pianoRollCompatible) {
            }

            public void beginPart(String string, PianoRollCompatible pianoRollCompatible) {
            }
        });
        return this.topGroup;
    }

    public NoteGroup createGroup() {
        return this.createGroup(new ArrayList<MusicXMLWrapper.Note>(0));
    }

    public NoteGroup createGroup(List<MusicXMLWrapper.Note> list) {
        return this.createGroup(list, null, Double.NaN);
    }

    public NoteGroup createGroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note) {
        return this.createGroup(list, note, Double.NaN);
    }

    public NoteGroup createGroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note, double d) {
        AbstractGroup abstractGroup;
        switch (this.type) {
            case 0: {
                abstractGroup = new NoteGroupType0();
                break;
            }
            case 1: {
                abstractGroup = new NoteGroupType1();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("illegal type: %d", this.type));
            }
        }
        for (MusicXMLWrapper.Note note2 : list) {
            abstractGroup.addNote(note2);
        }
        if (note != null) {
            abstractGroup.setApex(note);
        }
        abstractGroup.setApexSaliency(d);
        return abstractGroup;
    }

    public void setAspect(String string) {
        this.aspect = string;
    }

    public NoteGroup topgroup() {
        return this.topGroup;
    }

    public MusicApexWrapper toWrapper() {
        if (this.topGroup == null) {
            throw new RuntimeException("TopLevelGroup not created.");
        }
        MusicApexWrapper musicApexWrapper = MusicApexWrapper.createMusicApexWrapperFor(this.musicxml);
        musicApexWrapper.setAttribute("target", this.musicxml.getFileName());
        musicApexWrapper.setAttribute("apex-inherited", this.inherited ? "yes" : "no");
        if (this.aspect != null) {
            musicApexWrapper.setAttribute("aspect", this.aspect);
        }
        this.writeApexDataGroup(musicApexWrapper, this.topGroup);
        return musicApexWrapper;
    }

    private void writeApexDataGroup(MusicApexWrapper musicApexWrapper, NoteGroup noteGroup) {
        musicApexWrapper.addChild("group");
        if (noteGroup.depth() == -1) {
            throw new RuntimeException("Invalid GroupDepth");
        }
        musicApexWrapper.setAttribute("depth", noteGroup.depth());
        for (NoteGroup object : noteGroup.getSubgroups()) {
            this.writeApexDataGroup(musicApexWrapper, object);
        }
        if (!noteGroup.getNotes().isEmpty()) {
            for (MusicXMLWrapper.Note note : noteGroup.getNotes()) {
                musicApexWrapper.addChild("note");
                musicApexWrapper.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + note.getXPathExpression() + ")");
                musicApexWrapper.returnToParent();
            }
        } else {
            throw new RuntimeException("Creating No Notes Group");
        }
        if (noteGroup.getApexStart() != null && noteGroup.getApexStop() != null) {
            musicApexWrapper.addChild("apex");
            if (!Double.isNaN(noteGroup.getApexSaliency())) {
                musicApexWrapper.setAttribute("saliency", noteGroup.getApexSaliency());
            }
            musicApexWrapper.addChild("start");
            musicApexWrapper.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + noteGroup.getApexStart().getXPathExpression() + ")");
            musicApexWrapper.setAttribute("time", noteGroup.getApexStartTime());
            musicApexWrapper.returnToParent();
            musicApexWrapper.addChild("stop");
            musicApexWrapper.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + noteGroup.getApexStop().getXPathExpression() + ")");
            musicApexWrapper.setAttribute("time", noteGroup.getApexStopTime());
            musicApexWrapper.returnToParent();
            musicApexWrapper.returnToParent();
        }
        musicApexWrapper.returnToParent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApexDataGroup
    implements NoteGroup {
        private int depth = -1;
        private List<MusicXMLWrapper.Note> ownnotes = new ArrayList<MusicXMLWrapper.Note>();
        private List<MusicXMLWrapper.Note> undernotes = new ArrayList<MusicXMLWrapper.Note>();
        private List<NoteGroup> subGroups = new ArrayList<NoteGroup>();
        private MusicXMLWrapper.Note apex = null;
        private double saliency = Double.NaN;
        private HashMap<String, String> attribute = new HashMap();

        public ApexDataGroup() {
        }

        public ApexDataGroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note, double d) {
            this.ownnotes.addAll(list);
            this.undernotes.addAll(list);
            this.apex = note;
            this.saliency = d;
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public boolean isApexInherited() {
            return MusicApexDataSet.this.inherited;
        }

        @Override
        public double getApexSaliency() {
            return this.saliency;
        }

        @Override
        public List<MusicXMLWrapper.Note> getNotes() {
            return this.ownnotes;
        }

        @Override
        public List<MusicXMLWrapper.Note> getAllNotes() {
            return this.undernotes;
        }

        @Override
        public MusicXMLWrapper.Note getApex() {
            return this.apex;
        }

        @Override
        public List<NoteGroup> getSubgroups() {
            return this.subGroups;
        }

        @Override
        public void addNote(MusicXMLWrapper.Note note) {
            this.ownnotes.add(note);
            this.undernotes.add(note);
        }

        @Override
        public void removeNote(MusicXMLWrapper.Note note) {
            for (NoteGroup noteGroup : this.subGroups) {
                noteGroup.removeNote(note);
            }
            this.ownnotes.remove(note);
            this.undernotes.remove(note);
        }

        @Override
        public void addSubgroup(NoteGroup noteGroup) {
            if (noteGroup instanceof ApexDataGroup) {
                this.refreshSubGroup((ApexDataGroup)noteGroup, this.depth() + 1);
            }
            this.undernotes.addAll(noteGroup.getAllNotes());
            this.subGroups.add(noteGroup);
        }

        private void refreshSubGroup(ApexDataGroup apexDataGroup, int n) {
            apexDataGroup.depth = n;
            if (this.isApexInherited() && apexDataGroup.getNotes().contains(this.apex)) {
                apexDataGroup.apex = this.apex;
                apexDataGroup.saliency = this.saliency;
            }
            for (NoteGroup noteGroup : apexDataGroup.getSubgroups()) {
                apexDataGroup.refreshSubGroup((ApexDataGroup)noteGroup, n + 1);
            }
        }

        @Override
        public NoteGroup makeSubgroup(List<MusicXMLWrapper.Note> list) {
            return this.makeSubgroup(list, null);
        }

        public NoteGroup makeSubgroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note) {
            return this.makeSubgroup(list, note, Double.NaN);
        }

        public NoteGroup makeSubgroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note, double d) {
            for (MusicXMLWrapper.Note note2 : list) {
                Boolean bl = false;
                bl = this.ownnotes.contains(note2);
                if (!bl.booleanValue()) {
                    for (NoteGroup noteGroup : this.getSubgroups()) {
                        if (!noteGroup.getNotes().contains(note2)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl.booleanValue()) continue;
                throw new RuntimeException("Note is not included Parent and Parent's subgroups");
            }
            ApexDataGroup apexDataGroup = new ApexDataGroup();
            apexDataGroup.ownnotes.addAll(list);
            apexDataGroup.undernotes.addAll(list);
            apexDataGroup.depth = this.depth + 1;
            if (this.isApexInherited() && this.getApex() != null && apexDataGroup.ownnotes.contains(this.apex)) {
                apexDataGroup.apex = this.apex;
                apexDataGroup.saliency = this.saliency;
            } else {
                apexDataGroup.apex = note;
                apexDataGroup.saliency = d;
            }
            this.subGroups.add(apexDataGroup);
            this.ownnotes.removeAll(list);
            return apexDataGroup;
        }

        @Override
        public void setApex(MusicXMLWrapper.Note note) {
            if (this.apex != null) {
                throw new RuntimeException("This group already has Apex. : " + note.getXPathExpression());
            }
            this.apex = note;
        }

        public void setApex(MusicXMLWrapper.Note note, double d) {
            if (MusicApexDataSet.this.inherited) {
                throw new RuntimeException("This Apex is inherited");
            }
            this.apex = note;
            this.saliency = d;
        }

        @Override
        public void removeSubgroup(NoteGroup noteGroup) {
            this.ownnotes.addAll(noteGroup.getAllNotes());
            this.subGroups.remove(noteGroup);
        }

        @Override
        public String getAttribute(String string) {
            return this.attribute.get(string);
        }

        @Override
        public void setAttribute(String string, String string2) {
            this.attribute.put(string, string2);
        }

        @Override
        public List<MusicXMLWrapper.Note> getImplicitGroupNotes() {
            return null;
        }

        @Override
        public boolean isImplicit() {
            return false;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public MusicXMLWrapper.Note getApexStart() {
            return null;
        }

        @Override
        public double getApexStartTime() {
            return 0.0;
        }

        @Override
        public MusicXMLWrapper.Note getApexStop() {
            return null;
        }

        @Override
        public double getApexStopTime() {
            return 0.0;
        }

        @Override
        public void setApexSaliency(double d) {
        }

        @Override
        public void setApexStart(MusicXMLWrapper.Note note, double d) {
        }

        @Override
        public void setApexStop(MusicXMLWrapper.Note note, double d) {
        }

        @Override
        public void setImplicit(boolean bl) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoteGroupType1
    extends AbstractGroup {
        private NoteGroupType1() {
        }

        @Override
        public void addNote(MusicXMLWrapper.Note note) {
            if (this.underNotes.contains(note)) {
                throw new IllegalArgumentException("already contain");
            }
            if (this.depth <= 1) {
                this.ownNotes.add(note);
                this.underNotes.add(note);
                return;
            }
            this.underNotes.add(note);
            NoteGroup noteGroup = null;
            for (NoteGroup noteGroup2 : this.parent.subGroups) {
                if (noteGroup2 == this || !noteGroup2.getAllNotes().contains(note)) continue;
                ((NoteGroupType1)noteGroup2).removeNoteWithoutForce(note);
                noteGroup = noteGroup2;
                break;
            }
            if (noteGroup != null && noteGroup.getAllNotes().isEmpty()) {
                this.parent.subGroups.remove(noteGroup);
            }
            if (this.subGroups.isEmpty()) {
                this.ownNotes.add(note);
            } else {
                for (NoteGroup noteGroup2 : this.subGroups) {
                    try {
                        noteGroup2.addNote(note);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }

        @Override
        public void addSubgroup(NoteGroup noteGroup) {
            if (this.isImplicit()) {
                throw new IllegalStateException("group is implicit");
            }
            if (!this.subGroups.isEmpty()) {
                throw new IllegalStateException("group already has sub group");
            }
            if (!this.isContinuation(noteGroup.getAllNotes())) {
                throw new IllegalArgumentException("argument group is not continuous note sequence");
            }
            this.addSubgroupForce(noteGroup, this.ownNotes);
        }

        private void addSubgroupForce(NoteGroup noteGroup, List<MusicXMLWrapper.Note> list) {
            Object object;
            int n = 480;
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            for (MusicXMLWrapper.Note object22 : noteGroup.getAllNotes()) {
                n2 = Math.min(n2, object22.onset(n));
                n3 = Math.max(n3, object22.offset(n));
            }
            LinkedList linkedList = new LinkedList();
            LinkedList<MusicXMLWrapper.Note> linkedList2 = new LinkedList<MusicXMLWrapper.Note>();
            for (MusicXMLWrapper.Note note : list) {
                if (note.onset(n) < n2) {
                    linkedList.add(note);
                    continue;
                }
                if (note.offset(n) <= n3) continue;
                linkedList2.add(note);
            }
            if (!linkedList.isEmpty()) {
                object = (NoteGroupType1)MusicApexDataSet.this.createGroup(linkedList);
                ((AbstractGroup)object).setImplicit(true);
                ((NoteGroupType1)object).parent = this;
                ((NoteGroupType1)object).depth = this.depth + 1;
                this.subGroups.add(object);
            }
            this.subGroups.add(noteGroup);
            ((NoteGroupType1)noteGroup).parent = this;
            ((NoteGroupType1)noteGroup).depth = this.depth + 1;
            if (!linkedList2.isEmpty()) {
                object = (NoteGroupType1)MusicApexDataSet.this.createGroup(linkedList2);
                ((AbstractGroup)object).setImplicit(true);
                ((NoteGroupType1)object).parent = this;
                ((NoteGroupType1)object).depth = this.depth + 1;
                this.subGroups.add(object);
            }
        }

        @Override
        public NoteGroup makeSubgroup(List<MusicXMLWrapper.Note> list) {
            if (!this.subGroups.isEmpty()) {
                throw new IllegalStateException("group already has sub group");
            }
            if (!this.isContinuation(list)) {
                throw new IllegalArgumentException("argument group is not continuous note sequence");
            }
            for (MusicXMLWrapper.Note note : list) {
                if (this.underNotes.contains(note)) continue;
                throw new IllegalArgumentException("group has not contain note " + note);
            }
            NoteGroupType1 noteGroupType1 = (NoteGroupType1)MusicApexDataSet.this.createGroup(list);
            if (this.isImplicit()) {
                this.parent.subGroups.remove(this);
                ((NoteGroupType1)this.parent).addSubgroupForce(noteGroupType1, this.getAllNotes());
            } else {
                this.addSubgroup(noteGroupType1);
            }
            return noteGroupType1;
        }

        @Override
        public void removeNote(MusicXMLWrapper.Note note) {
            if (this.depth == 1) {
                throw new IllegalStateException("can't remove from top group");
            }
            int n = 480;
            NoteGroup noteGroup = this.parent;
            while (!noteGroup.getSubgroups().isEmpty()) {
                AbstractGroup abstractGroup = noteGroup;
                for (NoteGroup noteGroup2 : noteGroup.getSubgroups()) {
                    if (!noteGroup2.getAllNotes().contains(note)) continue;
                    noteGroup = noteGroup2;
                    break;
                }
                NoteGroup noteGroup2 = MusicApexDataSet.this.createGroup();
                noteGroup2.setImplicit(true);
                for (MusicXMLWrapper.Note note2 : noteGroup.getAllNotes()) {
                    if (note2.onset(n) < note.onset(n) || note2.offset(n) > note.offset(n)) continue;
                    noteGroup.getNotes().remove(note);
                    noteGroup.getAllNotes().remove(note);
                    noteGroup2.addNote(note2);
                }
                ((NoteGroupType1)abstractGroup).subGroups.add(noteGroup2);
            }
        }

        void removeNoteWithoutForce(MusicXMLWrapper.Note note) {
            for (NoteGroup noteGroup : this.subGroups) {
                ((NoteGroupType1)noteGroup).removeNoteWithoutForce(note);
            }
            this.ownNotes.remove(note);
            this.underNotes.remove(note);
        }

        @Override
        public void removeSubgroup(NoteGroup noteGroup) {
            if (!this.subGroups.contains(noteGroup)) {
                throw new IllegalArgumentException("argument is not sub group");
            }
            if (noteGroup.getSubgroups().isEmpty()) {
                int n;
                NoteGroup noteGroup22;
                List list = this.subGroups;
                if (list.size() == 1) {
                    this.subGroups.remove(noteGroup);
                    return;
                }
                boolean bl = true;
                for (NoteGroup noteGroup22 : list) {
                    if (noteGroup22 == noteGroup) continue;
                    bl &= noteGroup22.isImplicit();
                }
                if (bl) {
                    for (NoteGroup noteGroup22 : new ArrayList(list)) {
                        this.subGroups.remove(noteGroup22);
                    }
                    return;
                }
                Collections.sort(list, new Comparator<NoteGroup>(){

                    int noteGroupOnset(NoteGroup noteGroup) {
                        int n = 480;
                        int n2 = Integer.MAX_VALUE;
                        for (MusicXMLWrapper.Note note : noteGroup.getAllNotes()) {
                            n2 = Math.min(n2, note.onset(n));
                        }
                        return n2;
                    }

                    @Override
                    public int compare(NoteGroup noteGroup, NoteGroup noteGroup2) {
                        return this.noteGroupOnset(noteGroup) - this.noteGroupOnset(noteGroup2);
                    }
                });
                for (n = 0; n < list.size() && list.get(n) != noteGroup; ++n) {
                }
                if (n == 0) {
                    noteGroup22 = (NoteGroup)list.get(n + 1);
                    if (noteGroup22.isImplicit()) {
                        this.subGroups.remove(noteGroup);
                        for (MusicXMLWrapper.Note note : noteGroup.getAllNotes()) {
                            ((NoteGroupType1)noteGroup22).ownNotes.add(note);
                            ((NoteGroupType1)noteGroup22).underNotes.add(note);
                        }
                    } else {
                        noteGroup.setImplicit(true);
                    }
                } else if (n == list.size() - 1) {
                    noteGroup22 = (NoteGroup)list.get(n - 1);
                    if (noteGroup22.isImplicit()) {
                        this.subGroups.remove(noteGroup);
                        for (MusicXMLWrapper.Note note : noteGroup.getAllNotes()) {
                            ((NoteGroupType1)noteGroup22).ownNotes.add(note);
                            ((NoteGroupType1)noteGroup22).underNotes.add(note);
                        }
                    } else {
                        noteGroup.setImplicit(true);
                    }
                } else {
                    noteGroup22 = (NoteGroup)list.get(n - 1);
                    NoteGroup noteGroup3 = (NoteGroup)list.get(n + 1);
                    if (!noteGroup22.isImplicit() && !noteGroup3.isImplicit()) {
                        noteGroup.setImplicit(true);
                    } else if (noteGroup22.isImplicit() && noteGroup3.isImplicit()) {
                        this.subGroups.remove(noteGroup);
                        this.subGroups.remove(noteGroup3);
                        for (MusicXMLWrapper.Note note : noteGroup.getAllNotes()) {
                            noteGroup22.addNote(note);
                        }
                        for (MusicXMLWrapper.Note note : noteGroup3.getAllNotes()) {
                            noteGroup22.addNote(note);
                        }
                    } else {
                        this.subGroups.remove(noteGroup);
                        NoteGroup noteGroup4 = noteGroup22.isImplicit() ? noteGroup22 : noteGroup3;
                        for (MusicXMLWrapper.Note note : noteGroup.getAllNotes()) {
                            noteGroup4.addNote(note);
                        }
                    }
                }
            } else {
                this.decrementDepth(noteGroup);
                this.subGroups.remove(noteGroup);
                for (NoteGroup noteGroup5 : noteGroup.getSubgroups()) {
                    ((NoteGroupType1)noteGroup5).parent = this;
                    this.subGroups.add(noteGroup5);
                }
            }
        }

        void decrementDepth(NoteGroup noteGroup) {
            --((NoteGroupType1)noteGroup).depth;
            for (NoteGroup noteGroup2 : noteGroup.getSubgroups()) {
                this.decrementDepth(noteGroup2);
            }
        }

        boolean isContinuation(List<MusicXMLWrapper.Note> list) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Event
            implements Comparable<Event> {
                boolean onset;
                int tick;

                Event(MusicXMLWrapper.Note note, boolean bl) {
                    this.onset = bl;
                    this.tick = bl ? note.onset(480) : note.offset(480);
                }

                @Override
                public int compareTo(Event event) {
                    if (this.tick == event.tick) {
                        if (this.onset && !event.onset) {
                            return -1;
                        }
                        if (!this.onset && event.onset) {
                            return 1;
                        }
                    }
                    return this.tick - event.tick;
                }

                public String toString() {
                    return String.format("tick:%d, onset:%s", this.tick, this.onset);
                }
            }
            LinkedList<Event> linkedList = new LinkedList<Event>();
            for (MusicXMLWrapper.Note object : list) {
                linkedList.add(new Event(object, true));
                linkedList.add(new Event(object, false));
            }
            Collections.sort(linkedList);
            linkedList.removeLast();
            int n = 0;
            for (Event event : linkedList) {
                if (event.onset) {
                    ++n;
                    continue;
                }
                if (--n > 0) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoteGroupType0
    extends AbstractGroup {
        private NoteGroupType0() {
        }

        @Override
        public void addNote(MusicXMLWrapper.Note note) {
        }

        @Override
        public void addSubgroup(NoteGroup noteGroup) {
        }

        @Override
        public NoteGroup makeSubgroup(List<MusicXMLWrapper.Note> list) {
            return null;
        }

        @Override
        public void removeNote(MusicXMLWrapper.Note note) {
        }

        @Override
        public void removeSubgroup(NoteGroup noteGroup) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractGroup
    implements NoteGroup {
        final List<MusicXMLWrapper.Note> ownNotes = new ArrayList<MusicXMLWrapper.Note>();
        final List<MusicXMLWrapper.Note> underNotes = new ArrayList<MusicXMLWrapper.Note>();
        final List<NoteGroup> subGroups = new ArrayList<NoteGroup>();
        final HashMap<String, String> attribute = new HashMap();
        int depth = -1;
        MusicXMLWrapper.Note apexStart;
        MusicXMLWrapper.Note apexStop;
        double apexStartTime;
        double apexStopTime;
        double saliency = Double.NaN;
        boolean implicit = false;
        AbstractGroup parent;

        AbstractGroup() {
            this(null);
        }

        AbstractGroup(AbstractGroup abstractGroup) {
            this.parent = abstractGroup;
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public List<MusicXMLWrapper.Note> getNotes() {
            return this.ownNotes;
        }

        @Override
        public List<MusicXMLWrapper.Note> getAllNotes() {
            return this.underNotes;
        }

        @Override
        public List<NoteGroup> getSubgroups() {
            return this.subGroups;
        }

        @Override
        public MusicXMLWrapper.Note getApexStart() {
            return this.apexStart;
        }

        @Override
        public void setApexStart(MusicXMLWrapper.Note note, double d) {
            this.apexStart = note;
            this.apexStartTime = d;
        }

        @Override
        public double getApexStartTime() {
            return this.apexStartTime;
        }

        @Override
        public MusicXMLWrapper.Note getApexStop() {
            return this.apexStop;
        }

        @Override
        public void setApexStop(MusicXMLWrapper.Note note, double d) {
            this.apexStop = note;
            this.apexStopTime = d;
        }

        @Override
        public double getApexStopTime() {
            return this.apexStopTime;
        }

        @Override
        public MusicXMLWrapper.Note getApex() {
            if (this.apexStart != this.apexStop) {
                return this.apexStart;
            }
            throw new IllegalStateException("apexStart don't match apexStart");
        }

        @Override
        public void setApex(MusicXMLWrapper.Note note) {
            this.apexStart = this.apexStop = note;
            this.apexStartTime = 0.0;
            this.apexStopTime = note.actualDuration();
        }

        @Override
        public double getApexSaliency() {
            return this.saliency;
        }

        @Override
        public void setApexSaliency(double d) {
            this.saliency = d;
        }

        @Override
        public String getAttribute(String string) {
            return this.attribute.get(string);
        }

        @Override
        public List<MusicXMLWrapper.Note> getImplicitGroupNotes() {
            ArrayList<MusicXMLWrapper.Note> arrayList = new ArrayList<MusicXMLWrapper.Note>();
            arrayList.addAll(this.getNotes());
            for (NoteGroup noteGroup : this.subGroups) {
                if (!noteGroup.isImplicit()) continue;
                arrayList.addAll(noteGroup.getAllNotes());
            }
            return arrayList;
        }

        @Override
        public boolean isApexInherited() {
            return MusicApexDataSet.this.inherited;
        }

        @Override
        public boolean isImplicit() {
            return this.implicit;
        }

        @Override
        public void setImplicit(boolean bl) {
            this.implicit = bl;
        }

        @Override
        public int type() {
            return MusicApexDataSet.this.type;
        }

        @Override
        public void setAttribute(String string, String string2) {
            this.attribute.put(string, string2);
        }
    }
}

