/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NoteEvent
implements Comparable<NoteEvent> {
    double time;
    String msg;
    int notenum;
    int vel;

    NoteEvent(double d, MIDIXMLWrapper.MIDIEvent mIDIEvent) {
        this.time = d;
        this.msg = mIDIEvent.messageType();
        this.notenum = mIDIEvent.value(0);
        this.vel = mIDIEvent.value(1);
        if (this.vel == 0) {
            this.msg = "NoteOff";
        } else if (this.msg.equals("NoteOff")) {
            this.vel = 0;
        }
    }

    public String toString() {
        return String.format("%7f", this.time) + " " + this.msg + " " + this.notenum + " " + this.vel;
    }

    public boolean equals(Object object) {
        NoteEvent noteEvent = (NoteEvent)object;
        return noteEvent != null && this.time == noteEvent.time && this.msg.equals(noteEvent.msg) && this.notenum == noteEvent.notenum && this.vel == noteEvent.vel;
    }

    boolean approxEquals(NoteEvent noteEvent) {
        return noteEvent != null && Math.abs(this.time - noteEvent.time) < 0.02 && this.msg.equals(noteEvent.msg) && this.notenum == noteEvent.notenum && Math.abs(this.vel - noteEvent.vel) <= 1;
    }

    @Override
    public int compareTo(NoteEvent noteEvent) {
        if (this.notenum == noteEvent.notenum) {
            return this.time > noteEvent.time ? 1 : -1;
        }
        return this.notenum - noteEvent.notenum;
    }
}

