/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculator;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculatorFactory;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.DoubleArray;

public class F0PDFCalculatorModule
extends SPModule {
    private F0PDFCalculatorFactory factory = F0PDFCalculatorFactory.getFactory();
    private F0PDFCalculator f0calc;
    private boolean paramSet = false;
    private double nnFrom;
    private double nnThru;
    private double step;
    private String filterName = null;
    private PeakSet.Filter filter = null;

    protected String getParamCategory() {
        return "f0pdf";
    }

    protected String[] getUsedParamNames() {
        return new String[]{"NOTENUMBER_FROM", "NOTENUMBER_THRU", "STEP"};
    }

    private void setParams() {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        this.nnFrom = amusaParameterSet.getParamDouble("f0pdf", "NOTENUMBER_FROM");
        this.nnThru = amusaParameterSet.getParamDouble("f0pdf", "NOTENUMBER_THRU");
        this.step = amusaParameterSet.getParamDouble("f0pdf", "STEP");
        this.f0calc = this.factory.createCalculator(this.nnFrom, this.nnThru, this.step);
        String string = amusaParameterSet.getParam("f0pdf", "FILTER_NAME");
        if (string != null) {
            System.err.println(string);
            System.err.println(amusaParameterSet.getFilterParam(string, "LOW_CUT_FILTER"));
            this.filter = PeakSet.getFilter(amusaParameterSet.getFilterParam(string, "LOW_CUT_FILTER").equals("on"), amusaParameterSet.getFilterParamDouble(string, "LOW_CUT_BUTTOM"), amusaParameterSet.getFilterParamDouble(string, "LOW_CUT_TOP"), amusaParameterSet.getFilterParam(string, "HIGH_CUT_FILTER").equals("on"), amusaParameterSet.getFilterParamDouble(string, "HIGH_CUT_TOP"), amusaParameterSet.getFilterParamDouble(string, "HIGH_CUT_BUTTOM"));
        }
        this.paramSet = true;
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        if (!this.paramSet) {
            this.setParams();
        }
        PeakSet peakSet = (PeakSet)objectArray[0];
        if (this.filter != null) {
            peakSet.filter(this.filter);
        }
        timeSeriesCompatibleArray[0].add(this.f0calc.calcWeights(peakSet));
    }

    public Class[] getInputClasses() {
        return new Class[]{PeakSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{DoubleArray.class};
    }
}

