/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.sp.AbstractInterpolationModule;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.Utils;

class ExpInterpolationModule
extends AbstractInterpolationModule {
    private static final ExpInterpolationModule interp = new ExpInterpolationModule();
    private double c;

    ExpInterpolationModule() {
    }

    boolean isMissing(double d) {
        return Double.isInfinite(d) || Double.isNaN(d) || d == 0.0;
    }

    void calcCoefficient(int n, double d, int n2, double d2) {
        this.c = (Math.log(d2) - Math.log(d)) / (double)(n2 - n);
    }

    double calcValue(int n, int n2, double d, int n3, double d2) {
        return d * Math.exp(this.c * (double)(n - n2));
    }

    static ExpInterpolationModule getInstance() {
        return interp;
    }

    static void interpolateX(DoubleArray doubleArray, int n, int n2, int n3) {
        interp.run(doubleArray, n, n2, n3);
    }

    static void interpolateX(DoubleArray doubleArray, int n) {
        interp.run(doubleArray, n);
    }

    static DoubleArray interpolate(DoubleArray doubleArray, int n, int n2, int n3) {
        DoubleArray doubleArray2 = Utils.cloneArray(doubleArray);
        ExpInterpolationModule.interpolateX(doubleArray2, n, n2, n3);
        return doubleArray2;
    }

    static DoubleArray interpolate(DoubleArray doubleArray, int n) {
        DoubleArray doubleArray2 = Utils.cloneArray(doubleArray);
        ExpInterpolationModule.interpolateX(doubleArray2, n);
        return doubleArray2;
    }
}

