/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.toolbox;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkovGenerator<O extends Observation> {
    private final Hmm<O> hmm;
    private int stateNb;

    public MarkovGenerator(Hmm<O> hmm) {
        if (hmm == null) {
            throw new IllegalArgumentException("Invalid null HMM");
        }
        this.hmm = hmm;
        this.newSequence();
    }

    public O observation() {
        O o = this.hmm.getOpdf(this.stateNb).generate();
        double d = Math.random();
        for (int i = 0; i < this.hmm.nbStates() - 1; ++i) {
            double d2;
            d -= this.hmm.getAij(this.stateNb, i);
            if (!(d2 < 0.0)) continue;
            this.stateNb = i;
            return o;
        }
        this.stateNb = this.hmm.nbStates() - 1;
        return o;
    }

    public List<O> observationSequence(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Positive length required");
        }
        ArrayList<O> arrayList = new ArrayList<O>();
        while (n-- > 0) {
            arrayList.add(this.observation());
        }
        this.newSequence();
        return arrayList;
    }

    public void newSequence() {
        double d = Math.random();
        double d2 = 0.0;
        for (int i = 0; i < this.hmm.nbStates() - 1; ++i) {
            if (!((d2 += this.hmm.getPi(i)) > d)) continue;
            this.stateNb = i;
            return;
        }
        this.stateNb = this.hmm.nbStates() - 1;
    }

    public int stateNb() {
        return this.stateNb;
    }
}

