/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationVectorReader
extends ObservationReader<ObservationVector> {
    private int dimension;

    public ObservationVectorReader() {
        this.dimension = -1;
    }

    public ObservationVectorReader(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.dimension = n;
    }

    @Override
    public ObservationVector read(StreamTokenizer streamTokenizer) throws IOException, FileFormatException {
        if (streamTokenizer.nextToken() != 91) {
            throw new FileFormatException(streamTokenizer.lineno(), "'[' expected");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        block4: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -2: {
                    arrayList.add(new Double(streamTokenizer.nval));
                    continue block4;
                }
                case 93: {
                    if (arrayList.size() != 0) break block4;
                    throw new FileFormatException(streamTokenizer.lineno(), "Empty vector found");
                }
                default: {
                    throw new FileFormatException(streamTokenizer.lineno(), "Number or ']' expected");
                }
            }
            break;
        }
        if (streamTokenizer.nextToken() != 59) {
            throw new FileFormatException(streamTokenizer.lineno(), "';' expected");
        }
        if (this.dimension > 0 && arrayList.size() != this.dimension) {
            throw new FileFormatException(streamTokenizer.lineno(), "Bad observation: wrong dimension (" + arrayList.size() + " instead of " + this.dimension + ")");
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return new ObservationVector(dArray);
    }
}

