/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmmWriter {
    static DecimalFormat formatter = new DecimalFormat("#0.############");

    public static <O extends Observation> void write(Writer writer, OpdfWriter<? extends Opdf<O>> opdfWriter, Hmm<O> hmm) throws IOException {
        writer.write("Hmm v1.0\n\nNbStates " + hmm.nbStates() + "\n\n");
        for (int i = 0; i < hmm.nbStates(); ++i) {
            HmmWriter.writeState(writer, opdfWriter, hmm, i);
        }
    }

    private static <O extends Observation, D extends Opdf<O>> void writeState(Writer writer, OpdfWriter<D> opdfWriter, Hmm<O> hmm, int n) throws IOException {
        writer.write("State\n");
        if (hmm.getLabel(n) != null) {
            writer.write("Label " + hmm.getLabel(n) + "\n");
        }
        writer.write("Pi " + formatter.format(hmm.getPi(n)));
        writer.write("\nA ");
        for (int i = 0; i < hmm.nbStates(); ++i) {
            writer.write(formatter.format(hmm.getAij(n, i)) + " ");
        }
        writer.write("\n");
        Opdf<O> opdf = hmm.getOpdf(n);
        opdfWriter.write(writer, opdf);
        writer.write("\n\n");
    }
}

